/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ログメッセージ解析クラス syslogメッセージをMessageInfクラスに変換する。
 *
 * @version $Revision: 1.1.1.1 $
 * @since
 */
public class MessageParser {

	/** syslogメッセージの解析用フォーマット */
	static private MessageFormat m_msgfmt = new MessageFormat(
			"<{0}>{1,date,MMM dd HH:mm:ss} {2} {3}", Locale.ENGLISH);

	@SuppressWarnings("unused")
	private final static int INDEX_PRI = 0;

	private final static int INDEX_DATE = 1;

	private final static int INDEX_HOST = 2;

	private final static int INDEX_MSG = 3;

	//ロガー
	static Log log = LogFactory.getLog(MessageParser.class);

	/**
	 * メッセージ解析
	 * 
	 * @param msg
	 *            syslogメッセージ
	 * @return MessageInfクラス
	 */
	static public MessageInfo parse(String msg) {

		//MessageFormatクラスによるメッセージ解析
		Object[] parseArgs = null;
		try {
			parseArgs = m_msgfmt.parse(msg);
		} catch (ParseException e) {
			log.error(msg, e);
			return null;
		}
		if (log.isDebugEnabled()) {
			log.debug("parsed msg");
			for (int i = 0; i < parseArgs.length; i++) {
				log.debug(parseArgs[i]);
			}
		}

		//解析結果を　MessageInfo　にセット
		MessageInfo logMessage = new MessageInfo();
		logMessage.setHostName((String) parseArgs[INDEX_HOST]);
		logMessage.setMessage((String) parseArgs[INDEX_MSG]);
		logMessage.setGenerationDate(setYear((Date) parseArgs[INDEX_DATE]));

		return logMessage;
	}

	/**
	 * 日付決定処理.
	 * syslogメッセージの日付（月日）から、年を決定して日付を返す.
	 * 
	 * @param parseArgs	　日付の文字列
	 * @return	年を含めた日付
	 */
	static private Date setYear(Date date) {

		//現在時の取得
		Calendar nowDate = Calendar.getInstance();
		//戻り値用のカレンダー生成
		Calendar dataDate = Calendar.getInstance();

		//メッセージからparseしたDateを設定
		dataDate.setTime(date);

		//年を設定（メッセージに年が含まれないので1970になる）
		int monthNow = nowDate.get(Calendar.MONTH);
		int monthdat = dataDate.get(Calendar.MONTH);
		int year = nowDate.get(Calendar.YEAR);

		//メッセージの月が１２月で、現在が1月の場合、去年のデータとする
		if (monthdat == Calendar.DECEMBER && monthNow == Calendar.JANUARY) {
			year -= 1;
		}
		dataDate.set(Calendar.YEAR, year);

		log.debug(dataDate.getTime().toString());
		return dataDate.getTime();
	}
}
