/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.util.Date;

/**
 * syslogメッセージ情報クラス
 * メッセージのホスト名、発生日時、メッセージを格納する
 * 
 * @version $Revision: 1.1.1.1 $
 * @since
 */
public class MessageInfo {

	private String m_hostName;
	private Date m_generationDate;
	private String m_message;
	
	
	/**
	 * @return generationDate を戻します。
	 */
	public Date getGenerationDate() {
		return m_generationDate;
	}
	/**
	 * @param generationDate generationDate を設定。
	 */
	public void setGenerationDate(Date generationDate) {
		m_generationDate = generationDate;
	}
	/**
	 * @return hostName を戻します。
	 */
	public String getHostName() {
		return m_hostName;
	}
	/**
	 * @param hostName hostName を設定。
	 */
	public void setHostName(String hostName) {
		m_hostName = hostName;
	}
	/**
	 * @return message を戻します。
	 */
	public String getMessage() {
		return m_message;
	}
	/**
	 * @param message message を設定。
	 */
	public void setMessage(String message) {
		m_message = message;
	}
}
