/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * syslog転送メインクラス
 * 標準入力でメッセージを受け取り、ログ管理クラスへ渡す
 * 
 * @version $Revision: 1.1.1.1 $
 * @since
 */
public class LogForward {

	private LogManager m_manageLog;

	//ロガー
	static Log log = LogFactory.getLog(LogForward.class);

	/**
	 * 
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		log.debug("Start");

		LogForward logForward = new LogForward(args[0]);

		try {
			logForward.forward();
		} catch (Exception e) {
			log.error(e);
		}

		System.exit(0);

		log.debug("End");
	}

	/**
	 * コンストラクタ
	 * 
	 * @throws Exception
	 */
	LogForward(String propFileName) throws Exception {

	
		//プロパティファイル読み込み
		Properties props = new Properties();
		props.load(new FileInputStream(propFileName));

		m_manageLog = new LogManager(props);

		//ログ処理スレッドを開始
		m_manageLog.start();
		//スレッド待機待ち
		while (true) {
			if (m_manageLog.isWaiting())
				break;
		}
		
		//終了呼び出し設定
    	Runtime.getRuntime().addShutdownHook(new Thread() {
    	    public void run() { m_manageLog.interrupt(); }
    	});
		
	}

	/**
	 * メッセージ送信処理
	 * 
	 * @param msg
	 */
	private void put(String msg) {

		if (msg == null || msg.equals(""))
			return;

		log.debug("put Message:" + msg);

		m_manageLog.add(msg);

	}

	/**
	 * メッセージ転送処理
	 * 
	 * @throws Exception
	 */
	public void forward() throws Exception {

		log.debug("Read InputStaream");

		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		while (true) { /* 標準入力待ち */
			try {
				//1行受信したらメッセージ送信
				put(br.readLine());
			} catch (IOException e) {
				log.error(e);
				break;
			}
		}
		m_manageLog.interrupt();
	}

}
