/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.syslogng.forward;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.syslogng.bean.LogFilterInfo;

/**
 * ログフィルタリポジトリ情報.
 * ログのフィルタ情報と関連するファシリティのリストを格納する
 * 
 * @version $Revision: 1.1.1.1 $
 * @since
 */
public class LogFilterRepositoryInfo {

	private HashMap m_map = new HashMap();

	private LogFilterInfo m_filter = null;

	@SuppressWarnings("unused")
	private Log log = LogFactory.getLog(this.getClass());

	/**
	 * コンストラクタ
	 * @param filter　フィルタ情報
	 */
	public LogFilterRepositoryInfo(LogFilterInfo filter) {
		super();
		m_filter = filter;
	}

	/**
	 * ファシリティ情報設定
	 * @param map
	 */
	public void setMap(HashMap map) {
		m_map = map;

		
	}
	
	
	/**
	 * ファシリティID検索
	 * @param value
	 * @return
	 */
	public String contains(String value) {

		if(value == null)
			return null;
		
		Set entrySet = m_map.entrySet();
		for (Iterator iter = entrySet.iterator(); iter.hasNext();) {
			Map.Entry  entry = (Map.Entry ) iter.next();
			HashMap attr = (HashMap)entry.getValue();
			String host = (String)attr.get(FacilityAttributeConstant.NODENAME);
			if(host != null && host.equalsIgnoreCase(value) ){
				return (String)entry.getKey();
			}
		}
		return null;
	}
	
	/**
	 * ノード名取得
	 * @param value
	 * @return
	 */
	public String getNodeName(String facilityID) {

		HashMap attr = (HashMap)m_map.get(facilityID);
		return (String)attr.get(FacilityAttributeConstant.CN);
		
	}
	
	/**
	 * フィルター情報取得
	 * @return
	 */
	public LogFilterInfo getFilter() {
		return m_filter;
	}
}
