/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.sql.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import com.clustercontrol.sql.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * SQL監視を取得するクラスです。
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class GetSql {

    /**
     * SQL監視情報を返します。
     * 
     * @param monitorId 監視項目ID
     * @param monitorType 監視判定タイプ
     * @return SQL監視情報
     */
    public MonitorInfo getSql(String monitorId, int monitorType) {
    	
    	MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getSqlController();

    	MonitorInfo info = null;

    	try {
			info = sql.getSqlInfo(monitorId, monitorType);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (SchedulerException e) {
		} catch (NamingException e) {
		}

        return info;
    }
    
    /**
     * SQL監視一覧を返します。
     * 
     * @return SQL監視一覧
     */
    public ArrayList getSqlList() {
    	
    	MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getSqlController();

        ArrayList records = null;
        
        try {
			records = sql.getSqlList();
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (SchedulerException e) {
		} catch (NamingException e) {
		}

        return records;
    }
}