package com.clustercontrol.snmptrap.ejb.entity;

import java.util.Collection;

import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * @ejb.bean name="SnmpTrapMaster"
 *           jndi-name="SnmpTrapMaster"
 *           type="BMP"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAO"
 * impl-class="com.clustercontrol.snmptrap.dao.SnmpTrapMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 */
public abstract class SnmpTrapMasterBean implements EntityBean {
	
	protected String mib;
	protected String trapOid;
	protected Integer genericId;
	protected Integer specificId;
	protected String uei;
	protected Integer priority;
	protected String logmsg;
	protected String descr;
	
	
	/**
	 * @ejb.create-method 
	 */
	public SnmpTrapMasterPK ejbCreate(
			String mib, 
			String trapOid, 
			Integer genericId, 
			Integer specificId, 
			String uei, 
			Integer priority, 
			String logmsg, 
			String descr) throws javax.ejb.CreateException {
		
		this.mib = mib;
		this.trapOid = trapOid;
		this.genericId = genericId;
		this.specificId = specificId;
		this.uei = uei;
		this.priority = priority;
		this.logmsg = logmsg;
		this.descr = descr;
		
		return null;
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public SnmpTrapMasterPK ejbFindByPrimaryKey(SnmpTrapMasterPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByMib(String mib) throws FinderException {
		return null;
	}
	
	/**
	 * @return the mib
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getMib() {
		return mib;
	}
	
	/**
	 * @param java.lang.String the new mib value
	 * @ejb.interface-method
	 */
	public void setMib(String mib) {
		this.mib = mib;
	}
	
	/**
	 * @return the trapOid
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public String getTrapOid() {
		return trapOid;
	}
	
	/**
	 * @param java.lang.String the new trapOid value
	 * @ejb.interface-method
	 */
	public void setTrapOid(String trapOid) {
		this.trapOid = trapOid;
	}
	
	/**
	 * @return the genericId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public Integer getGenericId() {
		return genericId;
	}
	
	/**
	 * @param java.lang.String the new genericId value
	 * @ejb.interface-method
	 */
	public void setGenericId(Integer genericId) {
		this.genericId = genericId;
	}
	
	/**
	 * @return the specificId
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public Integer getSpecificId() {
		return specificId;
	}
	
	/**
	 * @param java.lang.String the new specificId value
	 * @ejb.interface-method
	 */
	public void setSpecificId(Integer specificId) {
		this.specificId = specificId;
	}
	
	/**
	 * @return the uei
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getUei() {
		return uei;
	}
	
	/**
	 * @param java.lang.String the new uei value
	 * @ejb.interface-method
	 */
	public void setUei(String uei) {
		this.uei = uei;
	}
	
	/**
	 * @return the logmsg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getLogmsg() {
		return logmsg;
	}
	
	/**
	 * @param java.lang.String the new logmsg value
	 * @ejb.interface-method
	 */
	public void setLogmsg(String logmsg) {
		this.logmsg = logmsg;
	}
	
	/**
	 * @return the descr
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public String getDescr() {
		return descr;
	}
	
	/**
	 * @param java.lang.String the new descr value
	 * @ejb.interface-method
	 */
	public void setDescr(String descr) {
		this.descr = descr;
	}
	
	/**
	 * @return the priority
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public Integer getPriority() {
		return priority;
	}
	
	/**
	 * @param java.lang.Integer the new priority value
	 * @ejb.interface-method
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}
	
	// ==========================================
	//  CMR fields
	// ==========================================
	/**
     * @ejb.interface-method view-type="local"
     */
    public SnmpTrapMibMasterLocal getSnmpTrapMibMaster() {
    	SnmpTrapMibMasterLocal snmpTrapMibMaster = null;
		try {
			snmpTrapMibMaster = SnmpTrapMibMasterUtil.getLocalHome().findByPrimaryKey(new SnmpTrapMibMasterPK(getMib()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return snmpTrapMibMaster;
	}
}
