/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.snmptrap.action;

import java.util.ArrayList;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.snmptrap.bean.OidTabelDefine;
import com.clustercontrol.util.Messages;

/**
 * OIDテーブル定義取得アクションクラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetOidTableDefine {

	/**
	 * OIDテーブル定義を返します。
	 * 
	 * @return OIDテーブル定義
	 */
	@SuppressWarnings("unchecked")
	public static ArrayList get() {
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(OidTabelDefine.MONITOR_ID, 
				new TableColumnInfo(Messages.getString("monitor.id"), TableColumnInfo.NONE, 0, SWT.LEFT));
		tableDefine.add(OidTabelDefine.MIB, 
				new TableColumnInfo(Messages.getString("mib"), TableColumnInfo.NONE, 0, SWT.LEFT));
		tableDefine.add(OidTabelDefine.TRAP_NAME, 
				new TableColumnInfo(Messages.getString("trap.name"), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(OidTabelDefine.TRAP_OID, 
				new TableColumnInfo(Messages.getString("oid"), TableColumnInfo.NONE, 120, SWT.LEFT));
		tableDefine.add(OidTabelDefine.GENERIC_ID, 
				new TableColumnInfo(Messages.getString("generic.id"), TableColumnInfo.NONE, 75, SWT.LEFT));
		tableDefine.add(OidTabelDefine.SPECIFIC_ID, 
				new TableColumnInfo(Messages.getString("specific.id"), TableColumnInfo.NONE, 75, SWT.LEFT));
		tableDefine.add(OidTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid") + "/" + Messages.getString("invalid"), TableColumnInfo.VALID, 80, SWT.LEFT));
		tableDefine.add(OidTabelDefine.PRIORITY, 
				new TableColumnInfo(Messages.getString("priority"), TableColumnInfo.PRIORITY, 70, SWT.LEFT));
		tableDefine.add(OidTabelDefine.MESSAGE, 
				new TableColumnInfo(Messages.getString("message"), TableColumnInfo.NONE, 150, SWT.LEFT));
		
		return tableDefine;
	}
}
