/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.clustercontrol.repository.bean.NodeScopeTabelDefine;
import com.clustercontrol.repository.bean.ScopeListTableDefine;
import com.clustercontrol.repository.factory.DeleteFacility;
import com.clustercontrol.repository.factory.ModifyFacility;
import com.clustercontrol.repository.factory.NodeFilterProperty;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.repository.factory.ScopeProperty;
import com.clustercontrol.repository.factory.SelectFacility;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="RepositoryController"	
 *           jndi-name="RepositoryController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *           
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class RepositoryControllerBean implements javax.ejb.SessionBean {
	protected static Log m_log = LogFactory.getLog( RepositoryControllerBean.class ); 
	
	private SessionContext m_context;
	
	public static final int ALL = 0;
	public static final int ONE_LEVEL = 1;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}

	/**
	 * ファシリティツリー取得(ノード含む)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return FacilityTreeItemの階層オブジェクト
	 * @throws FinderException
	 * @throws NamingException
	 */
	public FacilityTreeItem getFacilityTree(Locale locale) throws FinderException, NamingException {

		//ファシリティツリー(ノード含む)を取得
		SelectFacility select = new SelectFacility();
		FacilityTreeItem item = select.getFacilityTree(locale);

		return item;
	}
	
	/**
	 * ファシリティツリー取得(スコープのみ)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param locale
	 * @return FacilityTreeItemの階層オブジェクト
	 * @throws NamingException
	 * @throws FinderException
	 */
	public FacilityTreeItem getScopeFacilityTree(Locale locale) throws FinderException, NamingException {
		
		//ファシリティツリー(スコープのみ)を取得
		SelectFacility select = new SelectFacility();
		FacilityTreeItem item = select.getScopeFacilityTree(locale);

		return item;
	}
	
	/**
	 * ノード一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeListTableDefine(Locale local) {
		
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeListTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
		tableDefine.add(NodeListTabelDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", local), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
		tableDefine.add(NodeListTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * 割当スコープ一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeScopeTableDefine(Locale local) {
		
		//テーブル定義配列
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeScopeTabelDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", local), TableColumnInfo.NONE, 300, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * 割当スコープ一覧取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @return オブジェクトの2次元配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeScopeList(String facilityId) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeScopeList(facilityId);
		
		return list;
	}
	
	/**
	 * スコープ一覧テーブル定義取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScopeListTableDefine(Locale local) {
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(ScopeListTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", local), TableColumnInfo.FACILITY_ID, 100, SWT.LEFT));
		tableDefine.add(ScopeListTableDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", local), TableColumnInfo.FACILITY_NAME, 150, SWT.LEFT));
		tableDefine.add(ScopeListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 200, SWT.LEFT));

		return tableDefine;
	}
	

	/**
	 * スコープ一覧取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @return オブジェクトの2次元配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getScopeList(String parentFacilityId) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getScopeList(parentFacilityId);
		
		return list;
	}
	
	/**
	 * ノード一覧取得
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList() throws FinderException, NamingException {
	
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeList();

		return list;
	}
	
	/**
	 * ノード一覧取得
	 * 
	 * ファシリティIDの配下または直下のノード一覧を取得する
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return オブジェクトの2次元配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeList(parentFacilityId, level);

		return list;
	}
	
	/**
	 * ノード一覧取得
	 * 
	 * Propertyの検索条件に該当するノード一覧を取得する
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @return オブジェクトの2次元配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeList(Property property) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeList(property);

		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return ファシリティIDの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getFacilityIdList(parentFacilityId, level, false);

		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getFacilityIdList(parentFacilityId, level, sort);

		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @return ファシリティIDの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, false);

		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param parentFacilityId
	 * @param level
	 * @param sort
	 * @return ファシリティIDの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getNodeFacilityIdList(String parentFacilityId, int level, boolean sort) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(parentFacilityId, level, sort);

		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList() throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(false);

		return list;
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sort
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNodeFacilityIdList(boolean sort) throws FinderException, NamingException {
		
		//ファシリティツリーを取得
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getNodeFacilityIdList(sort);

		return list;
	}
	
	/**
	 * デバイス情報リスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @return DeviceDataの配列
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getDeviceList(String facilityId) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		ArrayList list = select.getDeviceList(facilityId);
		
		return list;
	}
	
	/**
	 * ノード詳細取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param attributes
	 * @return 属性名と値のHashMapとして返す
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(String facilityId, ArrayList attributes) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		HashMap map = select.getNodeDetail(facilityId, attributes);
		
		return map;
	}
	
	/**
	 * ノード詳細取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityIdList
	 * @param attributes
	 * @return ファシリティIDと属性値(属性名と値のHashMap)のHashMap
	 * @throws NamingException
	 * @throws FinderException
	 */
	public HashMap getNodeDetail(ArrayList facilityIdList, ArrayList attributes) throws FinderException, NamingException {
		
		SelectFacility select = new SelectFacility();
		HashMap map = select.getNodeDetail(facilityIdList, attributes);
		
		return map;
	}
	
	/**
	 * ノード詳細設定
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param attributes 属性名と値のHashMap
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void setNodeDetail(String facilityId, HashMap attributes) throws FinderException, NamingException {
		ModifyFacility modify = new ModifyFacility();
		modify.setNodeDetail(facilityId, attributes);
	}
	
	/**
	 * スコープ追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param property
	 * @throws CreateException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void addScope(String parentFacilityId, Property property) throws RemoveException, CreateException, NamingException {
		ModifyFacility modify = new ModifyFacility();
		modify.addScope(parentFacilityId, property);
	}
	
	/**
	 * スコープ変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyScope(Property property) throws NamingException, FinderException {
		ModifyFacility modify = new ModifyFacility();
		modify.modifyScope(property);
	}
	
	/**
	 * ノード追加
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void addNode(Property property) throws NamingException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyFacility modify = new ModifyFacility();
		modify.addNode(property, pri.getName());
	}
	
	/**
	 * ノード変更
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @throws NamingException
	 * @throws FinderException
	 * @throws CreateException
	 */
	public void modifyNode(Property property) throws NamingException, FinderException, CreateException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyFacility modify = new ModifyFacility();
		modify.modifyNode(property, pri.getName());
	}
	
	/**
	 * ノード変更(一括)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 2.0.0
	 * @since 1.0.0
	 * 
	 * @param property
	 * @param parentFacilityId
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void modifyNode(Property property, String parentFacilityId) throws NamingException, FinderException {
		Principal pri = m_context.getCallerPrincipal();
		
		ModifyFacility modify = new ModifyFacility();
		modify.modifyAllNode(property, parentFacilityId, pri.getName());
	}
	
	/**
	 * ノード削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	public void deleteNode(String facilityId) throws FinderException, RemoveException, NamingException {
		DeleteFacility delete = new DeleteFacility();
		delete.deleteNode(facilityId);
	}
	
	/**
	 * スコープ削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @throws FinderException
	 * @throws NamingException
	 * @throws RemoveException
	 */
	public void deleteScope(String facilityId) throws FinderException, NamingException, RemoveException {
		DeleteFacility delete = new DeleteFacility();
		delete.deleteScope(facilityId);
	}
	
	/**
	 * スコープへのノードの割り当て
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void assignNodeScope(String parentFacilityId, String[] facilityIds) throws NamingException, CreateException {
		ModifyFacility modify = new ModifyFacility();
		modify.assignNodeScope(parentFacilityId, facilityIds);
	}
	
	/**
	 * ノードのスコープからの削除
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryWrite"
     *     method-intf="Remote"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param parentFacilityId
	 * @param facilityIds
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws FinderException
	 */
	public void releaseNodeScope(String parentFacilityId, String[] facilityIds) throws FinderException, NamingException, RemoveException {
		DeleteFacility delete = new DeleteFacility();
		delete.releaseNodeScope(parentFacilityId, facilityIds);
	}
	
	/**
	 * スコープ用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getScopeProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
		ScopeProperty scope = new ScopeProperty();
		return scope.getProperty(facilityId, mode, local);
	}
	
	/**
	 * ノード用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param mode
	 * @param local
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getNodeProperty(String facilityId, int mode, Locale local) throws FinderException, NamingException {
		NodeProperty node = new NodeProperty();
		return node.getProperty(facilityId, mode, local);
	}
	
	/**
	 * ノード用プロパティ取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param local
	 * @return
	 */
	public Property getNodeFilterProperty(Locale local) {
		NodeFilterProperty node = new NodeFilterProperty();
		return node.getProperty(local);
	}
	
	/**
	 * ファシリティパス取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
     *     
     * @ejb.transaction
	 *     type="NotSupported"
	 *     
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param parentFacilityId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String getFacilityPath(String facilityId, String parentFacilityId) throws FinderException, NamingException {
		SelectFacility select = new SelectFacility();
		return select.getFacilityPath(facilityId, parentFacilityId);
	}
	
	/**
	 * ファシリティIDリスト取得
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param hostName
	 * @param ipAddress
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getFacilityIdList(String hostName, String ipAddress) throws FinderException, NamingException {
		SelectFacility select = new SelectFacility();
		return select.getFacilityIdList(hostName, ipAddress);
	}
	
    /**
     * ノードチェック
     * 
     * ファシリティIDがノードかチェックし、結果をbooleanで返す
     * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="RepositoryRead"
     *     method-intf="Remote"
	 *     
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @param facilityId
	 * @param parentFacilityId
	 * @return ファシリティIDの配列
	 * @throws FinderException
	 * @throws NamingException
	 */
	public boolean isNode(String facilityId) throws FinderException, NamingException {
		SelectFacility select = new SelectFacility();
		return select.isNode(facilityId);
	}
	
	/**
	 * セパレータ文字列を取得
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
     * @ejb.transaction
	 *     type="NotSupported"
	 * 
	 * @version 1.0.0
	 * @since 1.0.0
	 * 
	 * @return
	 */
	public String getSeparator() {
		return SelectFacility.SEPARATOR;
	}
}
