/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ノードの追加を行うクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class AddNodeProperty {

    // ----- instance メソッド ----- //

    /**
     * 指定したノードを追加します。
     * 
     * @param property
     *            属性情報
     * @return 登録に成功した場合、true
     */
    public boolean add(Property property) {
        PropertyUtil.deletePropertyDefine(property);

        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();

        try {
            repository.addNode(property);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (CreateException e) {
        }
        return false;
    }
}