/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.action.AddScopeProperty;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.dialog.ScopeCreateDialog;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.util.Messages;

/**
 * ノードの作成・変更ダイアログによる、ノード登録を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeAddAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.ScopeAddAction";

    //	 ----- instance フィールド ----- //

    private IViewPart viewPart; // ビュー

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // スコープツリーより、選択されているスコープを取得
        ScopeListView view = (ScopeListView) this.viewPart
                .getAdapter(ScopeListView.class);

        FacilityTreeComposite tree = view.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)view.getListComposite();
        
        FacilityTreeItem item = null;
        if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
        }
        else if(list.getTableViewer().getTable().isFocusControl()){
        	item = list.getSelectItem();
        }
        else{
        	return;
        }

        // 未選択もしくはノードを選択している場合は、処理終了
        if (item == null
                || item.getData().getType() == FacilityConstant.TYPE_NODE) {
            return;
        }
        
        FacilityTreeItem parent = item.getParent();

        // ダイアログを生成
        ScopeCreateDialog dialog = new ScopeCreateDialog(this.viewPart
                .getSite().getShell(), null, false);

        // ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
        if (dialog.open() == IDialogConstants.OK_ID) {
            Property property = dialog.getInputData();

            String parentId = item.getData().getFacilityId();

            if (new AddScopeProperty().add(parentId, property)) {
                // 成功報告ダイアログを生成
                MessageBox box = new MessageBox(this.viewPart.getSite()
                        .getShell(), SWT.ICON_INFORMATION);
                box.setText(Messages.getString("successful"));
                box.setMessage(Messages.getString("message.repository.14"));
                box.open();
            } else {
                // 失敗報告ダイアログを生成
                MessageBox box = new MessageBox(this.viewPart.getSite()
                        .getShell(), SWT.ICON_ERROR);
                box.setText(Messages.getString("failed"));
                box.setMessage(Messages.getString("message.repository.15"));
                box.open();
            }

            tree.update();
            view.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}