/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.repository.action.ModifyNodeProperty;
import com.clustercontrol.repository.bean.NodeListTabelDefine;
import com.clustercontrol.repository.dialog.NodeCreateDialog;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.util.Messages;

/**
 * ノードの作成・変更ダイアログによる、ノード変更を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class NodeModifyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.NodeModifyAction";

    //	 ----- instance フィールド ----- //

    private IViewPart viewPart; // ビュー

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // ノード一覧より、選択されているノードのファシリティIDを取得

        NodeListView view = (NodeListView) this.viewPart
                .getAdapter(NodeListView.class);

        StructuredSelection selection = (StructuredSelection) view
                .getComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        String facilityId = null;
        if (list != null) {
            facilityId = (String) list.get(NodeListTabelDefine.FACILITY_ID);
        }

        if (facilityId != null) {
            // ダイアログを生成
            NodeCreateDialog dialog = new NodeCreateDialog(this.viewPart
                    .getSite().getShell(), facilityId, true);

            // ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
            if (dialog.open() == IDialogConstants.OK_ID) {
                Property property = dialog.getInputData();

                boolean rtn = false;
                if (dialog.isNodeSelected()) {
                    rtn = new ModifyNodeProperty().edit(property);
                } else {
                	boolean done = false;
                	if(dialog.isClearDone()){
                		// クリアボタンがクリックされていた場合、更新処理を行う。
                		done = true;
                	}
                	else{
                		// 確認ダイアログを生成
                        MessageBox box = new MessageBox(this.viewPart.getSite().getShell(),
                                SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
                        box.setText(Messages.getString("confirmed"));
                        box.setMessage(Messages.getString("message.repository.20"));

                        // ダイアログにてOKが選択された場合、更新処理を行う。
                        if (box.open() == SWT.OK) {
                        	done = true;
                        }
                	}
                	
                	// スコープ単位で更新
                	if(done){
                		rtn = new ModifyNodeProperty().editAllInScope(property,
                                dialog.getScopeId());
                	}
                	else{
                		return;
                	}
                }

                if (rtn) {
                    // 成功報告ダイアログを生成
                    MessageBox box = new MessageBox(this.viewPart.getSite()
                            .getShell(), SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.repository.10"));
                    box.open();
                } else {
                    // 失敗報告ダイアログを生成
                    MessageBox box = new MessageBox(this.viewPart.getSite()
                            .getShell(), SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.repository.11"));
                    box.open();
                }

                view.update();

                // 選択させることで、他のビューの更新を促す。
                CommonTableViewer viewer = view.getComposite().getTableViewer();
                viewer.setSelection(viewer.getSelection());
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}