/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import com.clustercontrol.repository.view.NodeAttributeView;
import com.clustercontrol.repository.view.NodeListView;
import com.clustercontrol.repository.view.NodeScopeView;
import com.clustercontrol.repository.view.ScopeListView;

/**
 * リポジトリ機能のパースペクティブを生成するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RepositoryPerspective implements IPerspectiveFactory {

    /**
     * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
     */
    public void createInitialLayout(IPageLayout layout) {
        //アクションセットを追加
        layout.addActionSet("com.clustercontrol.ActionSet");
        layout.addActionSet("com.clustercontrol.collectiverun.ActionSet");
        layout.addActionSet("com.clustercontrol.jobmanagement.ActionSet");
        layout.addActionSet("com.clustercontrol.monitor.ActionSet");
        layout.addActionSet("com.clustercontrol.repository.ActionSet");
        layout.addActionSet("com.clustercontrol.syslogng.ActionSet");
        layout.addActionSet("com.clustercontrol.performance.ActionSet");
        layout.addActionSet("com.clustercontrol.accesscontrol.ActionSet");
        layout.addActionSet("com.clustercontrol.process.ActionSet");
        layout.addActionSet("com.clustercontrol.sql.ActionSet");
        layout.addActionSet("com.clustercontrol.ping.ActionSet");
        layout.addActionSet("com.clustercontrol.hinemosagent.ActionSet");
        layout.addActionSet("com.clustercontrol.snmp.ActionSet");
        layout.addActionSet("com.clustercontrol.priority.ActionSet");
        layout.addActionSet("com.clustercontrol.http.ActionSet");
        layout.addActionSet("com.clustercontrol.troubledetection.ActionSet");
        layout.addActionSet("com.clustercontrol.snmptrap.ActionSet");
        
        //エディタ領域を非表示にする
        layout.setEditorAreaVisible(false);

        //エディタ領域のIDを取得
        String editorArea = layout.getEditorArea();

        //エディタ領域の左部60%を占めるフォルダを作成
        IFolderLayout top = layout.createFolder("top", IPageLayout.LEFT,
                (float) 0.65f, editorArea);
        //エディタ領域の右部40%を占めるフォルダを作成
        IFolderLayout right = layout.createFolder("right", IPageLayout.RIGHT,
                (float) 0.35f, editorArea);
        //エディタ領域の下部34%を占めるフォルダを作成
        IFolderLayout middle = layout.createFolder("middle",
                IPageLayout.BOTTOM, (float) 0.34f, "top");
        //エディタ領域の下部34%を占めるフォルダを作成
        IFolderLayout bottom = layout.createFolder("bottom",
                IPageLayout.BOTTOM, (float) 0.5f, "middle");

        top.addView(NodeListView.ID);
        right.addView(NodeAttributeView.ID);
        middle.addView(NodeScopeView.ID);
        bottom.addView(ScopeListView.ID);
    }
}