/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.action;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import com.clustercontrol.ping.util.EjbConnectionManager;
import com.clustercontrol.ping.ejb.session.MonitorPingController;

/**
 * ping監視一覧テーブル定義情報を取得するクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetPingListTableDefine {

    /**
     * ping監視一覧のテーブル定義情報を返します。
     * 
     * @return ping監視一覧テーブル定義情報
     */
    public static ArrayList get() {
    	MonitorPingController ping = EjbConnectionManager.getConnectionManager()
                .getPingController();

        ArrayList tableDefine = null;
        try {
            tableDefine = ping.getPingListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
        }
        return tableDefine;
    }
}