/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performanceMGR.util;

import java.util.Properties;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoHome;

public class JNDIConnectionManager {
	public static InitialContext getInitialContext() throws NamingException{
		InitialContext iniCtx = null;
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			Properties properties = new Properties(); 
			properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
			properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
			properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
			
			iniCtx = new InitialContext(properties);
		}
		else{
			iniCtx = new InitialContext();
		}
		
		return iniCtx;
	}
	
	public static CollectorHome getCollectorHome() throws NamingException {
		Object obj = null;
		InitialContext initialContext = null;
		
		// 可用性対応 取得できるまで10回を上限にリトライする
		for(int i=0; i<10; i++){
			try {
				initialContext = getInitialContext();
				
				try {
					obj = initialContext.lookup(CollectorHome.JNDI_NAME);
				} catch (NamingException e) {
				}
			} finally {
				initialContext.close();
				
				if(obj != null){
					return (CollectorHome)PortableRemoteObject.narrow(obj, CollectorHome.class);
				} else {
					// 10秒待つ
					try {
						Thread.sleep(10000);
					} catch (InterruptedException e1) {
					}
				}
			}
		}
		
		throw new NamingException();
	}
	
	public static MonitorPerfInfoHome getMonitorPerfInfo() throws NamingException {
		InitialContext initialContext = getInitialContext();
		
		try {
			Object obj = initialContext.lookup(MonitorPerfInfoHome.JNDI_NAME);
			return (MonitorPerfInfoHome)PortableRemoteObject.narrow(obj, MonitorPerfInfoHome.class);
		} finally {
			initialContext.close();
		}
	}
}
