/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;
import com.clustercontrol.performance.view.RecordGraphView;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;

/**
 * 収集中データの実績のグラフ表示を行うアクションクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class ViewCurrentGraphAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.ViewCurrentGraphAction";
	
    private IViewPart viewPart; // ビュー

    /*
     * (非 Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {

        /*
         * 呼び出し元のViewを持ってきます。
         */
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        CurrentListView currentListView = (CurrentListView) page
                .findView(Messages.getString("VIEW_CURRENT_LIST"));

        /*
         * テーブルで選ばれている収集のIDを取得します。
         */
        String collectorID = currentListView.getSelectedID();

        if (collectorID != null) {
    		// アクセス権なしの場合、エラーダイアログを表示する
        	if(!RecordController.getInstance().checkPermissionRead()){
        		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
        				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
        		return;
        	}
        	
            // マネージャからプロパティ情報を収集する
            RecordController controller = RecordController.getInstance();
            // マネージャとの接続に失敗した場合はエラーダイアログを表示
            if (controller == null) {
                MessageDialog.openError(this.viewPart.getSite().getShell(),
                        Messages.getString("MESSAGE_0020"),  // "確認"
                        Messages.getString("CONNECTION_ERROR_MESSAGE"));
                return;
            }

            // 削除ロックをかける
            controller.lock(collectorID);
            
            CollectorProperty property = controller
                    .getCollectorProperty(collectorID);
            // 収集定義を取得できなかった場合はエラーダイアログを表示
            if (property == null) {
                MessageDialog.openError(this.viewPart.getSite().getShell(),
                        Messages.getString("MESSAGE_0020"),  // "確認"
                        Messages.getString("GET_PROPERTY_ERROR_MESSAGE"));
                return;
            }

            // 収集回数が0以下の場合はグラフ表示できない
            if (property.getCollectorData().getCount() <= 0) {
                MessageDialog
                .openError(
                        this.viewPart.getSite().getShell(),
                        Messages.getString("MESSAGE_0020"),  // "確認"
                        Messages.getString("INSUFFICIENT_DATA"));
                return;
            }

            // グラフビューに表示対象の収集定義を設定
            RecordGraphView recordGraphView = (RecordGraphView) page
                    .findView(Messages.getString("VIEW_RECORD_GRAPH"));
            recordGraphView.initialize(property);

            try {
                page.showView(Messages.getString("VIEW_RECORD_GRAPH"));
            } catch (PartInitException e) {
                String msg = Messages.getString("MESSAGE_0027");
                MessageDialog.openError(null,
                        Messages.getString("ERROR_IN_JP"), msg);
                return;
            }

            recordGraphView.setFocus();
        } else {
            String msg = Messages.getString("MESSAGE_0014");

            MessageDialog.openError(null,
                    Messages.getString("ERROR_IN_JP"), msg);
        }
    }

    /*
     * (非 Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}