/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.performance.action.RecordController;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performance.view.CurrentListView;

/**
 * 収集を停止するアクションクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class StopCollectorAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.StopCollectorAction";
	
    private IViewPart viewPart; // ビュー

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        this.viewPart = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {

        /*
         * 呼び出し元のViewを持ってきます。
         */
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        CurrentListView currentListView = (CurrentListView) page
                .findView(Messages.getString("VIEW_CURRENT_LIST"));

        /*
         * テーブルで選ばれている収集のIDを取得します。
         */
        if (currentListView.getSelectedID() != null) {
    		// アクセス権なしの場合、エラーダイアログを表示する
        	if(!RecordController.getInstance().checkPermissionExecute()){
        		MessageDialog.openInformation(null, com.clustercontrol.util.Messages.getString("message"),
        				com.clustercontrol.util.Messages.getString("message.accesscontrol.16"));
        		return;
        	}
        	
            String msg = Messages.getString("COLLECTION_ID") + currentListView.getSelectedID()
                    + Messages.getString("BACKSLASH_MSG_STOP_COLLECTING");

            if (MessageDialog.openQuestion(null, Messages
                    .getString("MESSAGE_0020"), msg)) {

                /*
                 * Beanを持ってきます。
                 */
                RecordController controller = RecordController.getInstance();
                // マネージャとの接続に失敗した場合はエラーダイアログを表示
                if (controller == null) {
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),  // "確認"
                            Messages.getString("CONNECTION_ERROR_MESSAGE"));
                    return;
                }

                if (!controller.stopRecordCollector(currentListView
                        .getSelectedID())) {
                    // 収集の停止に失敗した場合はエラーダイアログを表示
                    MessageDialog.openError(this.viewPart.getSite().getShell(),
                            Messages.getString("MESSAGE_0020"),  // "確認"
                            Messages.getString("STOP_COLLECTOR_ERROR_MESSAGE"));
                }

                //収集ステータスリストのリフレッシュを行います。
                currentListView.refresh();
            } else {
            }
        } else {

            String msg = Messages.getString("MESSAGE_0014");

            MessageDialog.openError(null,
                    Messages.getString("ERROR_IN_JP"), msg);
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}