/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.util;

import java.util.ArrayList;
import java.util.Date;

/**
 * グラフを４つ書くので共通部分（設定情報？）を保持するクラス
 * 
 * @version 1.0
 * @since 1.0
 */
public class RealtimeCollectorInfo {
	
	private int interval;
	private int requestInterval;
	private String facilityId;
	private int graphNum;
	
	private ArrayList subScopeFacilityId; // 制御用。
	private ArrayList subScopeFacilityName; // 見出用。制御用と使い方が異なるので別途配列を用意する。
	private int subScopeNum;
	
	private Date timestamp;
	private int timestampId;
	
	private Date collectStartTime;
	private Date collectEndTime;
	private Date graphStartTime;
	private Date graphEndTime;
	
	private int graphPlotNum;
	
	public RealtimeCollectorInfo() {
		super();
		initialize();
	}
	
	private void initialize() {
		// グラフの更新間隔
		interval = 0;
		// マネージャ側でのデータ収集間隔
		requestInterval = 0;
		// 選択されたfacilityId。則ち、グラフ表示の基準となるスコープの値
		// サブスコープ表示の場合は上位facilityに相当。
		facilityId = null;
		// Viewに表示するグラフ数
		graphNum = 4;  //現行仕様では4で固定。将来は増やすかも。
		
		subScopeNum = 0;
		timestamp = new Date(System.currentTimeMillis());
		timestampId = 0;
		
		collectStartTime = null; // 実績で利用.リアルタイムではnullのままとなる.timestampと共通化すべき.
		collectEndTime = null; // 実績で利用.リアルタイムではnullのままとなる.
		graphStartTime = null; // 実績で利用.リアルタイムではnullのままとなる.
		graphEndTime = null; // 実績で利用.リアルタイムではnullのままとなる.
		
		graphPlotNum = 0;	// 0はauto.
	}
	
	public void setInterval(int interval) {
		this.interval = interval;
	}
	
	public int getInterval() {
		return this.interval;
	}
	
	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	
	public String getFacilityId() {
		return this.facilityId;
	}
	
	public void setGraphNum(int graphNum) {
		this.graphNum = graphNum;
	}
	
	public int getGraphNum() {
		return this.graphNum;
	}
	
	public String getSubScopeFacilityId(int i) {
		return subScopeFacilityId.get(i).toString();
	}
	
	
	// String配列に仕様変更すべき.
	public void setSubScopeFacilityId(ArrayList subScopeFacilityId) {
		this.subScopeFacilityId = subScopeFacilityId;
	}
	
	// String配列に仕様変更すべき.
	public ArrayList getSubScopeFacilityName() {
		return subScopeFacilityName;
	}
	
	public void setSubScopeFacilityName(ArrayList subScopeFacilityName) {
		this.subScopeFacilityName = subScopeFacilityName;
	}
	
	public int getRequestInterval() {
		return requestInterval;
	}
	
	public void setRequestInterval(int requestInterval) {
		this.requestInterval = requestInterval;
	}
	
	public int getSubScopeNum() {
		return subScopeNum;
	}
	
	public void setSubScopeNum(int subScopeNum) {
		this.subScopeNum = subScopeNum;
	}
	public boolean isCurrentCollect(Date timestamp, int timestampId) {
		boolean ret = false;
		
		if (this.timestamp == timestamp && this.timestampId == timestampId) {
			ret = true;
		}
		return ret;
	}
	
	public int setCurrentCollect(Date timestamp) { //getよりsetがいい?
		if (timestamp.after(this.timestamp)) {
			this.timestamp = timestamp;
			this.timestampId = 0;
		} else if (this.timestamp == timestamp) {
			this.timestampId = this.timestampId + 1;
		} // これ以外のケースは想定外。後でハンドリングを記述する.
		return this.timestampId;
	}
	
	public Date getGraphStartTime() {
		return graphStartTime;
	}
	
	public void setGraphStartTime(Date graphStartTime) {
		this.graphStartTime = graphStartTime;
	}
	
	public Date getGraphEndTime() {
		return graphEndTime;
	}
	
	public void setGraphEndTime(Date graphEndTime) {
		this.graphEndTime = graphEndTime;
	}
	
	public Date getCollectStartTime() {
		return collectStartTime;
	}
	
	public void setCollectStartTime(Date collectStartTime) {
		this.collectStartTime = collectStartTime;
	}
	
	public Date getCollectEndTime() {
		return collectEndTime;
	}
	
	public void setCollectEndTime(Date collectEndTime) {
		this.collectEndTime = collectEndTime;
	}
	
	public int getGraphPlotNum() {
		return graphPlotNum;
	}
	
	public void setGraphPlotNum(int graphPlotNum) {
		this.graphPlotNum = graphPlotNum;
	}
}