/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */

package com.clustercontrol.performance.bean;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;

/**
 * 実績データグラフ表示用設定情報DTOクラス
 * 
 * @version 1.0
 * @since 1.0
 *  
 */
public class GraphProperty {

    /** 非表示 */
    public static final int INVISIBLE = 0;

    /** スコープ代表値 */
    public static final int TYPE1 = 1;

    /** スコープ代表値詳細 */
    public static final int TYPE2 = 2;

    /** サブスコープ代表値 */
    public static final int TYPE3 = 3;

    

    // DBMSなどに格納する上で判りやすいように文字表記とする.
    public static final String DISPLAY_NO = "DISPLAY_NO";  // NonDisplay
    
    public static final String DISPLAY_SELECTED_SCOPE = "DISPLAY_NO";  // SelectedScope

    public static final String DISPLAY_SCOPE_DETAILS = "DISPLAY_SCOPE_DETAILS";  // Detail

    public static final String DISPLAY_SUBSCOPE = "DISPLAY_SUBSCOPE";  // SubScope
    
    // グラフ詳細表示の可否の判定用.stringかbooleanかは要検討.
    public static final String BREAKDOWN_OK = "BREAKDOWN_OK";
    public static final String BREAKDOWN_NG = "BREAKDOWN_NG";
    
    
    
    
    
    private CollectorItemInfo targetItem; // グラフ表示対象項目

    FacilityTreeItem targetFacility; // グラフ表示対象ファシリティ

    int graphType; // グラフ表示方法

    /**
     * コンストラクター
     * 
     * @param targetFacility
     * @param targetItem
     * @param graphType
     */
    public GraphProperty(FacilityTreeItem targetFacility,
            CollectorItemInfo targetItem, int graphType) {

        this.targetFacility = targetFacility;
        this.targetItem = targetItem;
        this.graphType = graphType;
    }

    /**
     * graphType を取得します。
     * 
     * @return graphType
     */
    public int getGraphType() {
        return graphType;
    }

    /**
     * graphType を設定します。
     * 
     * @param graphType
     */
    public void setGraphType(int graphType) {
        this.graphType = graphType;
    }

    /**
     * targetFacility を取得します。
     * 
     * @return targetFacility
     */
    public FacilityTreeItem getTargetFacility() {
        return targetFacility;
    }

    /**
     * targetFacility を設定します。
     * 
     * @param targetFacility
     */
    public void setTargetFacility(FacilityTreeItem targetFacility) {
        this.targetFacility = (FacilityTreeItem) targetFacility;
    }

    /**
     * targetItem を取得します。
     * 
     * @return targetItem
     */
    public CollectorItemInfo getTargetItem() {
        return targetItem;
    }

    /**
     * targetItem を設定します。
     * 
     * @param targetItem
     */
    public void setTargetItem(CollectorItemInfo targetItem) {
        this.targetItem = targetItem;
    }
}