/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * システム通知情報削除クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteSystemNotify {
	
	protected static Log m_log = LogFactory.getLog( DeleteSystemNotify.class );
	
	/**
	 * システム通知情報を削除
	 * 
	 * @return 削除に成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean delete(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);
		
		SystemNotifyInfoLocal notify = null;
//		SendQueue queue = null;
		try 
		{
			// システム通知イベント情報を取得
			notify = SystemNotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
			
			// システム通知イベント情報を削除
			Collection ct = notify.getSystemNotifyEventInfo();
			this.deleteEvents(ct);
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			String[] args = { notifyId };
			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			String[] args = { notifyId };
			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
			String[] args = { notifyId };
			apllog.put("SYS", "003", args);
			m_log.debug("delete():" + e.getMessage());
			throw e;
		}
		
//		try 
//		{
//		// 通知情報を削除
//		notify.remove();
//		
//		NotifyInfoContext context = new NotifyInfoContext(NotifyInfoContext.TYPE_DELETE, notifyId, null);
//		
//		// 通知情報キャッシュを更新
//		queue = new SendQueue(QueueConstant.QUEUE_NAME_LOG);
//		queue.put(context);
//		queue.terminate();
//		
//		} catch (RemoveException e) {
//		AplLogger apllog = new AplLogger("NOTIFY", "notify");
//		String[] args = { notifyId };
//		apllog.put("SYS", "003", args);
//		m_log.debug("getNotify():" + e.getMessage());
//		throw e;
//		} catch (JMSException e) {
//		AplLogger apllog = new AplLogger("NOTIFY", "notify");
//		String[] args = { notifyId };
//		apllog.put("SYS", "003", args);
//		m_log.debug("add():" + e.getMessage());
//		throw e;
//		}
//		finally{
//		if(queue != null){
//		queue.terminate();	
//		}
//		}
		return true;
	}
	
	/**
	 * システム通知イベント情報を削除
	 * 
	 * @return 削除に成功した場合、true
	 * @throws RemoveException
	 */
	public boolean deleteEvents(Collection ct) throws RemoveException {
		
		// システム通知イベント情報を削除
		if(ct != null && ct.size() > 0){
			Object[] eventArray = ct.toArray();
			for(int j = 0; j < eventArray.length; j++){
				SystemNotifyEventInfoLocal event = (SystemNotifyEventInfoLocal)eventArray[j];
				if(event != null){
					event.remove();
				}
			}
		}
		return true;
	}
}
