/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyTabelDefine;
import com.clustercontrol.notify.factory.AddNotify;
import com.clustercontrol.notify.factory.AddSystemNotify;
import com.clustercontrol.notify.factory.DeleteNotify;
import com.clustercontrol.notify.factory.DeleteSystemNotify;
import com.clustercontrol.notify.factory.ModifyNotify;
import com.clustercontrol.notify.factory.ModifySystemNotify;
import com.clustercontrol.notify.factory.SelectNotify;
import com.clustercontrol.notify.factory.SelectSystemNotify;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="NotifyController"	
 *           jndi-name="NotifyController"
 *           type="Stateless"
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *            
 * <!-- end-xdoclet-definition --> 
 * @generated
*/
public abstract class NotifyControllerBean implements javax.ejb.SessionBean {

	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * 通知情報を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean addNotify(NotifyInfo info) throws CreateException, NamingException, JMSException {

		// 通知情報を登録
		AddNotify notify = new AddNotify();
		return  notify.add(info);
	}
	
	/**
	 * 通知情報を更新します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean modifyNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {

		// 通知情報を更新
		ModifyNotify notify = new ModifyNotify();
		return  notify.modify(info);
	}
	
	/**
	 * 通知情報を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param notifyId 通知ID
	 * @return 削除に成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean deleteNotify(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {

		// 通知情報を削除
		DeleteNotify notify = new DeleteNotify();
		return  notify.delete(notifyId);
	}
	
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param notifyId 通知ID
	 * @return 通知情報
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public NotifyInfo getNotify(String notifyId) throws FinderException, NamingException {

		// 通知情報を取得
		SelectNotify notify = new SelectNotify();
		NotifyInfo info = notify.getNotify(notifyId);

		return info;
	}
	
	/**
	 * 通知ID一覧を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return 通知ID一覧
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNotifyIdList() throws CreateException, FinderException, NamingException {

		// 通知ID一覧を取得
		SelectNotify notify = new SelectNotify();
		ArrayList list = notify.getNotifyIdList();

		return list;
	}
	
	/**
	 * 通知一覧リストを返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Objectの2次元配列
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getNotifyList() throws CreateException, FinderException, NamingException {

		// 通知一覧を取得
		SelectNotify notify = new SelectNotify();
		ArrayList list = notify.getNotifyList();

		return list;
	}
	
	/**
	 * 通知一覧マップを返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return 通知情報マップ（キー：通知ID）
	 * @throws FinderException
	 * @throws NamingException
	 */
	public HashMap<String, NotifyInfo> getNotifyMap() throws FinderException, NamingException {

		// 通知一覧を取得
		SelectNotify notify = new SelectNotify();
		HashMap<String, NotifyInfo> map = notify.getNotifyMap();

		return map;
	}
	
	/**
	 * 通知一覧のテーブル定義情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local ロケール
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNotifyListTableDefine(Locale local) {
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NotifyTabelDefine.NOTIFY_ID, 
				new TableColumnInfo(Messages.getString("notify.id", local), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", local), TableColumnInfo.NONE, 300, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.STATUS, 
				new TableColumnInfo(Messages.getString("status.katakana", local), TableColumnInfo.CHECKBOX, 60, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.EVENT, 
				new TableColumnInfo(Messages.getString("event.katakana", local), TableColumnInfo.CHECKBOX, 60, SWT.LEFT));
		tableDefine.add(NotifyTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", local), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * システム通知情報を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean addSystemNotify(NotifyInfo info) throws CreateException, NamingException, JMSException {

		// システム通知情報を登録
		AddSystemNotify notify = new AddSystemNotify();
		return  notify.add(info);
	}
	
	/**
	 * システム通知情報を更新します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean modifySystemNotify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {

		// システム通知情報を更新
		ModifySystemNotify notify = new ModifySystemNotify();
		return  notify.modify(info);
	}
	
	/**
	 * システム通知情報を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyWrite"
     *     method-intf="Remote"
	 * 
	 * @param notifyId 通知ID
	 * @return 削除に成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean deleteSystemNotify(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {

		// システム通知情報を削除
		DeleteSystemNotify notify = new DeleteSystemNotify();
		return  notify.delete(notifyId);
	}
	
	/**
	 * システム通知情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="NotifyRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param notifyId 通知ID
	 * @return 通知情報
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public NotifyInfo getSystemNotify(String notifyId) throws FinderException, NamingException {

		// システム通知情報を取得
		SelectSystemNotify notify = new SelectSystemNotify();
		NotifyInfo info = notify.getNotify(notifyId);

		return info;
	}
}
