/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 
 * @ejb.bean name="NotifyInfo"
 *     jndi-name="NotifyInfo"
 *     type="CMP"
 *     primkey-field="notifyId"
 *     schema="NotifyInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyInfo as a"  
 *     signature="java.util.Collection findAll()"
 *     
 * @ejb.finder
 *    query=""
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 * @jboss.query
 *    query="SELECT OBJECT(a) FROM NotifyInfo as a ORDER BY a.notifyId"
 *    signature="java.util.Collection findAllOrderByNotifyId()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="java.lang.String"
 *           
 */
public abstract class NotifyInfoBean implements EntityBean {
	
	public void setEntityContext(EntityContext ctx)
		throws EJBException,
		RemoteException {
	}

	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
  /**
   *
   * <!-- begin-user-doc -->
   * The  ejbCreate method.
   * <!-- end-user-doc -->
   *
   * <!-- begin-xdoclet-definition --> 
   * @ejb.create-method 
   * <!-- end-xdoclet-definition --> 
   * @generated
   */
  public java.lang.String ejbCreate(
			String notifyId,
			String description,
			Integer statusFlg,
			Integer statusValidPeriod,
			Integer statusInvalidFlg,
			Integer statusUpdatePriority,
			Integer eventFlg,
			Integer inhibitionFlg,
			Integer inhibitionFrequency,
			Integer inhibitionPeriod,
			Timestamp regDate,
			Timestamp updateDate) throws javax.ejb.CreateException {

  	
		setNotifyId(notifyId);
		setDescription(description);
		setStatusFlg(statusFlg);
		setStatusValidPeriod(statusValidPeriod);
		setStatusInvalidFlg(statusInvalidFlg);
		setStatusUpdatePriority(statusUpdatePriority);
		setEventFlg(eventFlg);
		setInhibitionFlg(inhibitionFlg);
		setInhibitionFrequency(inhibitionFrequency);
		setInhibitionPeriod(inhibitionPeriod);
		setRegDate(regDate);
		setUpdateDate(updateDate);
	    return null;
	}

	public void ejbRemove()
		throws RemoveException,
		EJBException,
		RemoteException {

	}

	public void ejbActivate() throws EJBException, RemoteException {
	}

	public void ejbPassivate() throws EJBException, RemoteException {
	}

	public void ejbLoad() throws EJBException, RemoteException {
	}

	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public abstract String getNotifyId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param notifyId The notifyId to set.
	 */
	public abstract void setNotifyId(String notifyId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public abstract String getDescription();

	/**
	 * @ejb.interface-method
	 * 
	 * @param description The description to set.
	 */
	public abstract void setDescription(String description);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param eventFlg The eventFlg to set.
	 */
	public abstract Integer getEventFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param eventFlg The eventFlg to set.
	 */
	public abstract void setEventFlg(Integer eventFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFlg The inhibitionFlg to set.
	 */
	public abstract Integer getInhibitionFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFlg The inhibitionFlg to set.
	 */
	public abstract void setInhibitionFlg(Integer inhibitionFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_frequency"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFrequency The inhibitionFrequency to set.
	 */
	public abstract Integer getInhibitionFrequency();

	/**
	 * @ejb.interface-method
	 * 
	 * @param inhibitionFrequency The inhibitionFrequency to set.
	 */
	public abstract void setInhibitionFrequency(Integer inhibitionFrequency);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="inhibition_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param inhibitionPeriod The inhibitionPeriod to set.
	 */
	public abstract Integer getInhibitionPeriod();

	/**
	 * @ejb.interface-method
	 * 
	 * @param inhibitionPeriod The inhibitionPeriod to set.
	 */
	public abstract void setInhibitionPeriod(Integer inhibitionPeriod);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract Timestamp getRegDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract void setRegDate(Timestamp regDate);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param statusFlg The statusFlg to set.
	 */
	public abstract Integer getStatusFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param statusFlg The statusFlg to set.
	 */
	public abstract void setStatusFlg(Integer statusFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_invalid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param statusInvalidFlg The statusInvalidFlg to set.
	 */
	public abstract Integer getStatusInvalidFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param statusInvalidFlg The statusInvalidFlg to set.
	 */
	public abstract void setStatusInvalidFlg(Integer statusInvalidFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_update_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param statusUpdatePriority The statusUpdatePriority to set.
	 */
	public abstract Integer getStatusUpdatePriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param statusUpdatePriority The statusUpdatePriority to set.
	 */
	public abstract void setStatusUpdatePriority(Integer statusUpdatePriority);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="status_valid_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param statusValidPeriod The statusValidPeriod to set.
	 */
	public abstract Integer getStatusValidPeriod();

	/**
	 * @ejb.interface-method
	 * 
	 * @param statusValidPeriod The uid to statusValidPeriod.
	 */
	public abstract void setStatusValidPeriod(Integer statusValidPeriod);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract void setUpdateDate(Timestamp updateDate);
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyEventInfo"
	 * role-name="NotifyInfo-NotifyEventInfo(single)"
	 * 
	 * @return Returns the collection.
	 * 
	 */
	public abstract Collection getNotifyEventInfo();
	
	/**
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param collection The collection to set.
	 */
	public abstract void setNotifyEventInfo(Collection collection);
}
