/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 
 * @ejb.bean name="NotifyEventInfo"
 *     jndi-name="NotifyEventInfo"
 *     type="CMP"
 *     primkey-field="notifyId","priority"
 *     schema="NotifyEventInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_event_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyEventInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyEventInfoPK"
 *           
 */
public abstract class NotifyEventInfoBean implements EntityBean {
	
	public void setEntityContext(EntityContext ctx)
		throws EJBException,
		RemoteException {
	}

	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
  /**
   *
   * <!-- begin-user-doc -->
   * The  ejbCreate method.
   * <!-- end-user-doc -->
   *
   * <!-- begin-xdoclet-definition --> 
   * @ejb.create-method 
   * <!-- end-xdoclet-definition --> 
   * @generated
   */
  public NotifyEventInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer eventNormalFlg,
			Integer eventNormalState,
			Integer eventInhibitionFlg,
			Integer eventInhibitionState,
			Integer mailFlg,
			String mailAddress) throws javax.ejb.CreateException {
  	
		setNotifyId(notifyId);
		setPriority(priority);
		setEventNormalFlg(eventNormalFlg);
		setEventNormalState(eventNormalState);
		setEventInhibitionFlg(eventInhibitionFlg);
		setEventInhibitionState(eventInhibitionState);
		setMailFlg(mailFlg);
		setMailAddress(mailAddress);
	    return null;
	}

	public void ejbRemove()
		throws RemoveException,
		EJBException,
		RemoteException {

	}

	public void ejbActivate() throws EJBException, RemoteException {
	}

	public void ejbPassivate() throws EJBException, RemoteException {
	}

	public void ejbLoad() throws EJBException, RemoteException {
	}

	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the notifyId.
	 */
	public abstract String getNotifyId();
	
	/**
	 * @ejb.interface-method
	 * 
	 * @param notifyId The notifyId to set.
	 */
	public abstract void setNotifyId(String notifyId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the priority.
	 */
	public abstract Integer getPriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param priority The description to set.
	 */
	public abstract void setPriority(Integer priority);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_normal_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the eventNormalFlg.
	 */
	public abstract Integer getEventNormalFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param eventNormalFlg The eventNormalFlg to set.
	 */
	public abstract void setEventNormalFlg(Integer eventNormalFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_normal_state"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the eventNormalState.
	 */
	public abstract Integer getEventNormalState();

	/**
	 * @ejb.interface-method
	 * 
	 * @param eventNormalState The eventNormalState to set.
	 */
	public abstract void setEventNormalState(Integer eventNormalState);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the eventInhibitionFlg.
	 */
	public abstract Integer getEventInhibitionFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param eventInhibitionFlg The eventInhibitionFlg to set.
	 */
	public abstract void setEventInhibitionFlg(Integer eventInhibitionFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="event_inhibition_state"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the eventInhibitionState.
	 */
	public abstract Integer getEventInhibitionState();

	/**
	 * @ejb.interface-method
	 * 
	 * @param eventInhibitionState The eventInhibitionState to set.
	 */
	public abstract void setEventInhibitionState(Integer eventInhibitionState);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @param Returns the mailFlg.
	 */
	public abstract Integer getMailFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param mailFlg The mailFlg to set.
	 */
	public abstract void setMailFlg(Integer mailFlg);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="mail_address"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the mailAddress.
	 */
	public abstract String getMailAddress();

	/**
	 * @ejb.interface-method
	 * 
	 * @param mailAddress The mailAddress to set.
	 */
	public abstract void setMailAddress(String mailAddress);
	

	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="NotifyInfo-NotifyEventInfo"
     * role-name="NotifyEventInfo-NotifyInfo(multi)"
     * cascade-delete="yes"
     * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * 
     */
    public abstract NotifyInfoLocal getNotifyInfo();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
