/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.view.ScopeListBaseView;

/**
 * ビューの更新を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RefreshAction implements IViewActionDelegate {

	/** ビュー */	
    private IViewPart viewPart;
    

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * スコープツリーを持つビューを更新します。
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.view.ScopeListBaseView
     */
    public void run(IAction action) {
        ScopeListBaseView view = (ScopeListBaseView) viewPart
                .getAdapter(ScopeListBaseView.class);

        view.update();
    }

    /**
     * 選択を変更した際に呼ばれます。
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}