/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.view.action;

import java.util.ArrayList;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.action.ReportEvent;
import com.clustercontrol.monitor.dialog.EventReportDialog;
import com.clustercontrol.monitor.util.EventReportGenerator;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.util.Messages;

/**
 * 監視[イベントのダウンロード]ダイアログによるイベントの帳票出力処理を行うアクションクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class EventReportAction implements IViewActionDelegate {
	
	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.DownloadAction";
	
	/** ビュー */
	private IViewPart viewPart;
	
	
	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}
	
	/**
	 * 監視[イベントのダウンロード処理]ダイアログで指定された条件に一致するイベントを取得し、
     * 帳票を出力します。
     * <p>
	 * <ol>
	 * <li>監視[イベントのダウンロード処理]ダイアログを表示します。</li>
	 * <li>ダイアログで指定された出力情報、検索条件を取得します。</li>
	 * <li>スコープツリーで選択されているアイテムより、ファシリティIDを取得します。</li>
	 * <li>ファシリティIDと検索条件に一致するイベント情報一覧を取得します。 </li>
	 * <li>帳票を出力します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.monitor.dialog.EventReportDialog
     * @see com.clustercontrol.monitor.action.ReportEvent#getEventInfo(String, Property)
     * @see com.clustercontrol.monitor.util.EventReportGenerator#run(String, Property, ArrayList, int, String)
	 */
	public void run(IAction action) {
		EventView view = (EventView) this.viewPart.getAdapter(EventView.class);
		
		// ダイアログを生成
		EventReportDialog dialog = new EventReportDialog(this.viewPart.getSite().getShell());
		
		// ダイアログにて出力が選択された場合、帳票出力
		if (dialog.open() == IDialogConstants.OK_ID) {
			
			FacilityTreeItem item = view.getScopeTreeComposite().getSelectItem();
			String facilityId = null;
			if (item != null) {
				facilityId = item.getData().getFacilityId();
			}
			Property condition = dialog.getInputData();
			int outputForm = dialog.getOutputForm();
			String redirect = dialog.getRedirect();
			
			// イベント一覧取得
			ArrayList list = new ReportEvent().getEventInfo(facilityId, condition);
			
			// 追加：出力イベント件数が0件の場合、その旨をつたえるダイアログを表示
                        if(list.size() == 0){
                                MessageBox box = new MessageBox(this.viewPart.getSite().getShell(), SWT.OK | SWT.ICON_INFORMATION);
                                box.setText(Messages.getString("failed"));
                                box.setMessage(Messages.getString("message.monitor.49"));
                                box.open();
                        }
			else {
				// 帳票出力
				EventReportGenerator report = new EventReportGenerator();
				if(report.run(facilityId, condition, list, outputForm, redirect)){
					String[] args = { redirect };
				
					MessageBox box = new MessageBox(this.viewPart.getSite().getShell(), SWT.OK | SWT.ICON_INFORMATION);
					box.setText(Messages.getString("successful"));
					box.setMessage(Messages.getString("message.monitor.45",args));
					box.open();
				}
				else{
					MessageBox box = new MessageBox(this.viewPart.getSite().getShell(), SWT.OK | SWT.ICON_ERROR);
					box.setText(Messages.getString("failed"));
					box.setMessage(Messages.getString("message.monitor.46"));
					box.open();
				}
			}
		}
	}
	
	/**
	 * 選択を変更した際に呼ばれます。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}
}
