/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.dialog.EventFilterDialog;
import com.clustercontrol.monitor.view.EventView;

/**
 * 監視[イベントのフィルタ処理]ダイアログによるイベントの取得処理を行うアクションクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventFilterAction implements IViewActionDelegate {
	
	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.EventFilterAction";

	/** ビュー */
    private IViewPart viewPart;


    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * 監視[イベントのフィルタ処理]ダイアログで指定された条件に一致するイベント情報を取得し、
     * ビューを更新します。
     * <p>
	 * <ol>
	 * <li>監視[イベントのフィルタ処理]ダイアログを表示します。</li>
	 * <li>ダイアログで指定された検索条件を取得します。</li>
	 * <li>監視[イベント]ビューの検索条件に設定します。</li>
	 * <li>監視[イベント]ビューを更新します。</li>
	 * </ol>
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.monitor.dialog.EventFilterDialog
     * @see com.clustercontrol.monitor.view.EventView#setCondition(Property)
     * @see com.clustercontrol.monitor.view.EventView#update() 
     */
    public void run(IAction action) {
        EventView view = (EventView) this.viewPart.getAdapter(EventView.class);

        if (action.isChecked()) {
            // ダイアログを生成
            EventFilterDialog dialog = new EventFilterDialog(this.viewPart
                    .getSite().getShell());

            // ダイアログにて検索が選択された場合、検索結果をビューに表示
            if (dialog.open() == IDialogConstants.OK_ID) {

                Property condition = dialog.getInputData();

                view.setCondition(condition);
                view.update();
            } else {
                action.setChecked(false);
            }
        } else {
            // 検索条件クリア
            view.setCondition(null);
            // スコープツリーのアイテムを再選択(スコープパス文字列の再表示のため)
            TreeViewer tree = view.getScopeTreeComposite().getTreeViewer();

            // スコープツリーのアイテムが選択されていた場合
            if (((StructuredSelection) tree.getSelection()).getFirstElement() != null) {
                tree.setSelection(tree.getSelection()); // ビューの更新も行われる
            }
            // スコープツリーのアイテムが選択されていない場合
            else {
                view.update();
            }
        }
    }

    /**
     * 選択を変更した際に呼ばれます。
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}