/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

import com.clustercontrol.monitor.ui.MonitorUIPlugin;
import com.clustercontrol.monitor.view.EventView;
import com.clustercontrol.monitor.view.ScopeView;
import com.clustercontrol.monitor.view.StatusView;
import com.clustercontrol.util.Messages;

/**
 * 監視管理のプレファレンスページクラスです。
 * 
 * @version 2.1.1
 * @since 1.0.0
 */
public class MonitorPreferencePage extends FieldEditorPreferencePage implements
        IWorkbenchPreferencePage {

    /** 監視[スコープ]ビューの自動更新フラグ */
    public static final String P_SCOPE_UPDATE_FLG = "scopeUpdateFlg";

    /** 監視[スコープ]ビューの自動更新周期 */
    public static final String P_SCOPE_UPDATE_CYCLE = "scopeUpdateCycle";

    /** 監視[ステータス]ビューの自動更新フラグ */
    public static final String P_STATUS_UPDATE_FLG = "statusUpdateFlg";

    /** 監視[ステータス]ビューの自動更新周期 */
    public static final String P_STATUS_UPDATE_CYCLE = "stateUpdateCycle";

    /** 監視[イベント]ビューの自動更新フラグ */
    public static final String P_EVENT_UPDATE_FLG = "eventUpdateFlg";

    /** 監視[イベント]ビューの自動更新周期 */
    public static final String P_EVENT_UPDATE_CYCLE = "eventUpdateCycle";

    /** 監視[イベント]ビューのメッセージ表示 */
    public static final String P_EVENT_MESSAGE_FLG = "eventMessageFlg";
    
    /** 監視[イベント]ビューの表示イベント数 */
    public static final String P_EVENT_MAX = "eventMaxMessages";
    
    private static final String MSG_ENABLE = 
    	Messages.getString("autoupdate.enable");
    
    private static final String MSG_CYCLE = 
    	Messages.getString("autoupdate.cycle") + " : ";
    
    private static final String MSG_MESSAGE = 
    	Messages.getString("over.limit.message");
    
    private static final String MSG_MAX_EVENTS = 
    	Messages.getString("number.of.display.events") + " : ";
    

    /**
     * 初期値が設定されたインスタンスを返します。
     * 
     * @see #initializeDefaults()
     */
    public MonitorPreferencePage() {
        super(GRID);
        this.setPreferenceStore(MonitorUIPlugin.getDefault()
                .getPreferenceStore());

        this.initializeDefaults();
    }

    /**
     * 初期値を設定します。
     */
    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();

        store.setDefault(P_SCOPE_UPDATE_FLG, true);
        store.setDefault(P_SCOPE_UPDATE_CYCLE, 10);
        store.setDefault(P_STATUS_UPDATE_FLG, true);
        store.setDefault(P_STATUS_UPDATE_CYCLE, 10);
        store.setDefault(P_EVENT_UPDATE_FLG, true);
        store.setDefault(P_EVENT_UPDATE_CYCLE, 10);
        store.setDefault(P_EVENT_MESSAGE_FLG, true);
        store.setDefault(P_EVENT_MAX, 500);
    }

    /**
     * 設定フィールドを生成します。
     */
    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;

        // スコープ監視ビュー関連
        Group scopeGroup = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        scopeGroup.setLayoutData(gridData);
        scopeGroup.setText(Messages.getString("view.monitor.scope"));
        // フラグ
        this.addField(new BooleanFieldEditor(P_SCOPE_UPDATE_FLG, MSG_ENABLE,
                scopeGroup));
        // 周期
        this.addField(new IntegerFieldEditor(P_SCOPE_UPDATE_CYCLE, MSG_CYCLE,
                scopeGroup));

        // ステータス監視ビュー関連
        Group statusGroup = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        statusGroup.setLayoutData(gridData);
        statusGroup.setText(Messages.getString("view.monitor.status"));
        // フラグ
        this.addField(new BooleanFieldEditor(P_STATUS_UPDATE_FLG, MSG_ENABLE,
                statusGroup));
        // 周期
        this.addField(new IntegerFieldEditor(P_STATUS_UPDATE_CYCLE, MSG_CYCLE,
                statusGroup));

        // イベント監視ビュー関連
        Group eventGroup = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        eventGroup.setLayoutData(gridData);
        eventGroup.setText(Messages.getString("view.monitor.event"));
        // フラグ
        this.addField(new BooleanFieldEditor(P_EVENT_UPDATE_FLG, MSG_ENABLE,
                eventGroup));
        // 周期
        this.addField(new IntegerFieldEditor(P_EVENT_UPDATE_CYCLE, MSG_CYCLE,
                eventGroup));
        // メッセージ表示
        this.addField(new BooleanFieldEditor(P_EVENT_MESSAGE_FLG, MSG_MESSAGE,
                eventGroup));
        // 表示イベント数
        this.addField(new IntegerFieldEditor(P_EVENT_MAX, MSG_MAX_EVENTS,
                eventGroup));
    }

    /**
     * 設定内容を各ビューに反映します。
     * 
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        boolean result = super.performOk();

        this.applySetting();

        return result;
    }

    /**
     * 設定内容を反映します。
     */
    protected void applySetting() {
        IPreferenceStore store = this.getPreferenceStore();

        // 存在するビュー全てに設定を適応する。

        IWorkbench workbench = MonitorUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();

        int windowCount = windows.length;

        for (int i = 0; i < windowCount; i++) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int pageCount = pages.length;

            for (int j = 0; j < pageCount; j++) {
                ScopeView scopeView = (ScopeView) pages[j]
                        .findView(ScopeView.ID);
                if (scopeView != null) {
                    int cycle = store.getInt(P_SCOPE_UPDATE_CYCLE);
                    scopeView.setInterval(cycle);
                    if (store.getBoolean(P_SCOPE_UPDATE_FLG)) {
                        scopeView.startAutoReload();
                    } else {
                        scopeView.stopAutoReload();
                    }
                }

                StatusView statusView = (StatusView) pages[j]
                        .findView(StatusView.ID);
                if (statusView != null) {
                    int cycle = store.getInt(P_STATUS_UPDATE_CYCLE);
                    statusView.setInterval(cycle);
                    if (store.getBoolean(P_STATUS_UPDATE_FLG)) {
                        statusView.startAutoReload();
                    } else {
                        statusView.stopAutoReload();
                    }
                }

                EventView eventView = (EventView) pages[j]
                        .findView(EventView.ID);
                if (eventView != null) {
                    int cycle = store.getInt(P_EVENT_UPDATE_CYCLE);
                    eventView.setInterval(cycle);
                    if (store.getBoolean(P_EVENT_UPDATE_FLG)) {
                        eventView.startAutoReload();
                    } else {
                        eventView.stopAutoReload();
                    }
                }
            }
        }
    }

    /**
     * 初期化します。
     * 
     * @param workbench ワークベンチオブジェクト
     */
    public void init(IWorkbench workbench) {
    }
}