/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TransactionManagerを管理するクラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class MonitorTransactionManager {
	
	protected static Log m_log = LogFactory.getLog( MonitorTransactionManager.class );
    
	private static MonitorTransactionManager m_instance = null;
	private InitialContext m_ctx = null;
	
	/**
	 * このオブジェクトを取得
	 * シングルトン
	 * @return　MonitorTransactionManager トランザクションマネージャ
	 */
	public static MonitorTransactionManager getInstance() {
		if (m_instance==null) {
			m_instance = new MonitorTransactionManager();
		}
		return m_instance;
	}

	private MonitorTransactionManager() {
		try {
			m_ctx = new InitialContext();
		} catch (NamingException e) {
			m_log.error("TransactionManager:" + e.getMessage());
		}
	}
	
	/**
	 * TransactionManagerを取得
	 * 
	 * @return　TransactionManager
	 */
	public synchronized TransactionManager getTransactionManager() throws NamingException {
	    if(m_ctx == null){
			try {
				m_ctx = new InitialContext();
			} catch (NamingException e) {
				m_log.error("getTransactionManager:" + e.getMessage());
				throw e;
			}
		}
		
		try {
			// TransactionManagerをルックアップ
			TransactionManager tm = (TransactionManager)m_ctx.lookup("java:/TransactionManager");
			return tm;
		} catch (NamingException e) {
			m_ctx = null;
			
			m_log.error("getTransactionManager:" + e.getMessage());
			throw e;
		}
	}
}
