/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.QuartzConstant;
import com.clustercontrol.monitor.run.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;

/**
 * スケジュール検索クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class SelectSchedule {
    protected static Log m_log = LogFactory.getLog( SelectSchedule.class );

    /** ジョブ名リスト */
    protected String[] m_jobs = null;
    
	/**
	 * スケジュール有効/無効取得
	 * 
	 * @param monitorTypeId 監視対象ID
     * @param monitorId 監視項目ID
     * @return 有効/無効
     * @throws NamingException
     * @throws SchedulerException
	 * @throws CreateException 
	 * @throws RemoteException 
     */
	public int getValid(String monitorTypeId, String monitorId) throws NamingException, SchedulerException {
		
        //QuartzのSchedulerをルックアップ
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //ジョブ名リスト取得
        try {
			m_jobs = manager.getJobs(monitorTypeId);
		} catch (RemoteException e) {
		}
		
        //ジョブ名リスト取得
        for(int i = 0; i < m_jobs.length; i++){
            //ジョブ(JobDetail)取得
            JobDetail job = null;
			try {
				job = manager.getJobDetail(m_jobs[i], monitorTypeId);
			} catch (RemoteException e) {
			}

            // ジョブ名を取得
            if(monitorId.equals(job.getName())){
            	// 有効/無効を取得
                Integer valid = (Integer)job.getJobDataMap().get(QuartzConstant.VALID_KEY);
                if(valid != null){
                	return valid.intValue();
                }
                else{
                	return -1;
                }
            }
        }
	    return -1;
    }
}
