/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoLocal;

/**
 * 真偽値監視クラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class RunMonitorTruthValueType extends RunMonitor{
	
	protected static Log m_log = LogFactory.getLog( RunMonitorTruthValueType.class );
	
	/** 監視取得値 */
	protected boolean m_value;

	/**
	 * コンストラクタ
	 * 
	 */
	public RunMonitorTruthValueType() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * 監視対象に対する監視情報を収集
	 * <p>
	 * 
	 * 指定されたファシリティIDの監視情報を収集し、
	 * m_valueに監視取得値を設定して下さい。
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true
	 */
	@Override
	public abstract boolean collect(String facilityId);
	
	/* (非 Javadoc)
	 * 判定結果値を設定
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setCheckResult(boolean)
	 */
	@Override
	public int getCheckResult(boolean ret) {
		
		int result = -1;
		
		// 値取得の成功時
		if(ret){
			if(m_value){
				// 真
				result = TruthConstant.TYPE_TRUE;
			}
			else{
				// 偽
				result = TruthConstant.TYPE_FALSE;
			}
		}
		return result;
	}
	
	/* (非 Javadoc)
	 * 真偽値監視判定情報を設定
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setJudgementInfo()
	 */
	@Override
	public void setJudgementInfo() {
		
		// 真偽値監視判定値、ログ出力メッセージ情報を取得
		Collection ct = m_monitor.getMonitorTruthValueInfo();
        Iterator itr = ct.iterator();
		
        m_judgementInfoList = new TreeMap<Integer, MonitorJudgementInfo>();
        MonitorTruthValueInfoLocal local = null;
        while(itr.hasNext()){
        	
            local = (MonitorTruthValueInfoLocal)itr.next();
            Integer truthValue = local.getTruthValue();
            
            MonitorTruthValueInfo info = new MonitorTruthValueInfo();
            info.setTruthValue(truthValue.intValue());
            info.setPriority(local.getPriority().intValue());
            info.setMessageId(local.getMessageId());
            info.setMessage(local.getMessage());
            info.setJobRun(local.getJobRun().intValue());
            info.setJobId(local.getJobId());
            info.setJobInhibitionFlg(local.getJobInhibitionFlg().intValue());
            info.setJobFailurePriority(local.getJobFailurePriority().intValue());
            
            m_judgementInfoList.put(truthValue, info);
        }
	}
}
