/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoLocal;

/**
 * 文字列監視クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
abstract public class RunMonitorStringValueType extends RunMonitor{
	
	protected static Log m_log = LogFactory.getLog( RunMonitorStringValueType.class );
	
	/** 監視取得値 */
	protected String m_value;
	
	/** 個別の通知ID @version 2.1.0 */
	protected String m_separateNotifyId;
	
	
	/**
	 * コンストラクタ
	 * 
	 * @throws NamingException
	 * @throws JMSException
	 * @throws CreateException
	 */
	public RunMonitorStringValueType() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * 監視対象に対する監視情報を収集
	 * <p>
	 * 
	 * 指定されたファシリティIDの監視情報を収集し、
	 * m_valueに監視取得値を設定して下さい。
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true 
	 */
	@Override
	public abstract boolean collect(String facilityId);
	
	/* (非 Javadoc)
	 * 判定結果値を設定
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getPriority(boolean)
	 */
	@Override
	public int getCheckResult(boolean ret) {
		
		int result = -1;
		boolean matchFlg = false;
		m_separateNotifyId = m_notifyId;
				
		// 値取得の成功時
		if(ret){
			MonitorStringValueInfo info = null;
			Pattern pattern = null;
			Matcher matcher = null;
			
			// 文字列監視判定情報で順番にフィルタリング
			Set set = m_judgementInfoList.keySet();
			for (Iterator iter = set.iterator(); iter.hasNext();) {
				Integer key = (Integer)iter.next();
				info = (MonitorStringValueInfo) m_judgementInfoList.get(key);
				
				// この設定が有効な場合
				if (info != null && info.isValidFlg()) {
					try {
						String patternText = info.getPattern();
						
						pattern = Pattern.compile(patternText, Pattern.DOTALL);
						matcher = pattern.matcher(m_value);
						
						// パターンマッチ表現でマッチング
						if (matcher.matches()) {
							
							result = info.getOrderNo();
							
							// 条件に一致したら処理する場合
							if (info.getProcessType() == ProcessConstant.TYPE_YES) {
								
								m_log.debug("getCheckResult(): マッチ。説明：" + info.getDescription() + "，値：" + m_value);
								
								// 個別の通知ID指定
								if(info.getNotifyId() != null && !"".equals(info.getNotifyId())){
									m_separateNotifyId = info.getNotifyId(); 
								}
								matchFlg = true;
								break;
								
							// 条件に一致したら処理しないならば、処理終了
							} else {
								m_log.debug("getCheckResult():" + info.getDescription() + ":" + m_value);
								break;
							}
						}
					} catch(PatternSyntaxException e){
						m_log.error("getCheckResult(): パターンマッチ表現が無効。説明："+info.getDescription() + "，パターンマッチ表現："+info.getPattern() + "，値：" + m_value, e);
						
					} catch (Exception  e) {
						m_log.error("getCheckResult(): パターンマッチ表現が無効。説明："+info.getDescription() + "，パターンマッチ表現："+info.getPattern() + "，値：" + m_value, e);
					}
				}
			}
			if(!matchFlg){
				// 条件に一致したら処理しない または 条件に一致しない場合、通知しない
				m_separateNotifyId = null; 
			}
		}
		return result;
	}

	/* (非 Javadoc)
	 * 文字列監視判定情報を設定
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setJudgementInfo()
	 */
	@Override
	public void setJudgementInfo() {
		
		// 文字列監視判定値、ログ出力メッセージ情報を取得
		Collection ct = m_monitor.getMonitorStringValueInfo();
        Iterator itr = ct.iterator();
		
        m_judgementInfoList = new TreeMap<Integer, MonitorJudgementInfo>();
        MonitorStringValueInfoLocal local = null;
        while(itr.hasNext()){
        	
            local = (MonitorStringValueInfoLocal)itr.next();
            Integer order = local.getOrderNo().intValue();
            
            MonitorStringValueInfo info = new MonitorStringValueInfo();
            info.setOrderNo(order.intValue());
            info.setDescription(local.getDescription());
            info.setPattern(local.getPattern());
            info.setProcessType(local.getProcessType().intValue());
            info.setNotifyId(local.getNotifyId());
            info.setPriority(local.getPriority().intValue());
            info.setMessageId(local.getMessageId());
            info.setMessage(local.getMessage());
            info.setJobRun(local.getJobRun().intValue());
            info.setJobId(local.getJobId());
            info.setJobInhibitionFlg(local.getJobInhibitionFlg().intValue());
            info.setJobFailurePriority(local.getJobFailurePriority().intValue());
            info.setValidFlg(ValidConstant.typeToBoolean(local.getValidFlg().intValue()));

            m_judgementInfoList.put(order, info);
        }
	}
	
	/* (非 Javadoc)
	 * 通知IDを取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getNotifyId()
	 */
	@Override
	public String getNotifyId() {
		return m_separateNotifyId;
	}
}
