/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

import javax.ejb.CreateException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;

/**
 * 数値監視クラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
abstract public class RunMonitorNumericValueType extends RunMonitor{
	
	protected static Log m_log = LogFactory.getLog( RunMonitorNumericValueType.class );
	
	/** 監視取得値 */
	protected double m_value;
	
	/**
	 * コンストラクタ
	 * 
	 */
	public RunMonitorNumericValueType() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/**
	 * 監視対象に対する監視情報を収集
	 * <p>
	 * 
	 * 指定されたファシリティIDの監視情報を収集し、
	 * m_valueに監視取得値を設定して下さい。
	 * 
	 * @param facilityId ファシリティID
	 * @return 値取得に成功した場合、true 
	 */
	@Override
	public abstract boolean collect(String facilityId);
	
	/* (非 Javadoc)
	 * 判定結果値を設定
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setCheckResult(boolean)
	 */
	@Override
	public int getCheckResult(boolean ret) {

		int result = -1;
		MonitorNumericValueInfo info = null;
		
		// 値取得の成功時
		if(ret){
			
			// 通知の範囲をチェック
			info = (MonitorNumericValueInfo)m_judgementInfoList.get(Integer.valueOf(PriorityConstant.TYPE_INFO));
			if(m_value >= info.getThresholdLowerLimit() && m_value <= info.getThresholdUpperLimit()){
				result = PriorityConstant.TYPE_INFO;
			}
			else{
				// 警告の範囲チェック
				info = (MonitorNumericValueInfo)m_judgementInfoList.get(Integer.valueOf(PriorityConstant.TYPE_WARNING));
				if(m_value >= info.getThresholdLowerLimit() && m_value <= info.getThresholdUpperLimit()){
					result = PriorityConstant.TYPE_WARNING;
				}
				else{
					// 危険（通知・警告以外）
					result = PriorityConstant.TYPE_CRITICAL;
				}
			}
		}
		return result;
	}
	
	/* (非 Javadoc)
	 * 数値監視判定情報を設定
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#setJudgementInfo()
	 */
	@Override
	public void setJudgementInfo() {

		// 数値監視判定値、ログ出力メッセージ情報を取得
		Collection ct = m_monitor.getMonitorNumericValueInfo();
        Iterator itr = ct.iterator();
		
        m_judgementInfoList = new TreeMap<Integer, MonitorJudgementInfo>();
        MonitorNumericValueInfoLocal local = null;
        while(itr.hasNext()){
        	
            local = (MonitorNumericValueInfoLocal)itr.next();
            Integer priority = local.getPriority();
            
            MonitorNumericValueInfo info = new MonitorNumericValueInfo();
            info.setPriority(priority.intValue());
            info.setThresholdLowerLimit(local.getThresholdLowerLimit().doubleValue());
            info.setThresholdUpperLimit(local.getThresholdUpperLimit().doubleValue());
            info.setMessageId(local.getMessageId());
            info.setMessage(local.getMessage());
            info.setJobRun(local.getJobRun().intValue());
            info.setJobId(local.getJobId());
            info.setJobInhibitionFlg(local.getJobInhibitionFlg().intValue());
            info.setJobFailurePriority(local.getJobFailurePriority().intValue());
            
            m_judgementInfoList.put(priority, info);
        }
	}

	/* (非 Javadoc)
	 * 重要度を取得
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getPriority(int)
	 */
	@Override
	public int getPriority(int id) {
		
		// 重要度が判定情報IDとなっているため、そのままリターン
		if(id == PriorityConstant.TYPE_INFO ||
				id == PriorityConstant.TYPE_WARNING ||
				id == PriorityConstant.TYPE_CRITICAL){
			return id;
		}
		else{
			return m_failurePriority;
		}
	}
}
