/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoUtil;

/**
 * 真偽値監視判定情報更新クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
abstract public class ModifyMonitorTruthValueType extends ModifyMonitor{
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorTruthValueType.class );
	
	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.ModifyMonitor#modifyJudgementInfo()
	 */
	@Override
	@SuppressWarnings("unchecked")
	public boolean modifyJudgementInfo() throws CreateException, RemoveException, NamingException {
		
		// 真偽値監視判定情報を削除
		Collection ct = m_monitor.getMonitorTruthValueInfo();
	    if(ct != null && ct.size() > 0){
	        Object[] infoArray = ct.toArray();
	        for(int j = 0; j < infoArray.length; j++){
	        	MonitorTruthValueInfoLocal info = (MonitorTruthValueInfoLocal)infoArray[j];
	            if(info != null){
	            	info.remove();
	            }
	        }
	    }		
		
		// 真偽値監視判定情報を設定
		ArrayList valueList = m_monitorInfo.getJudgementInfo();
		ArrayList<MonitorTruthValueInfoLocal> valueLocalList = new ArrayList<MonitorTruthValueInfoLocal>();
		
		MonitorTruthValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = (MonitorTruthValueInfo)valueList.get(index);
			if(value != null){
				MonitorTruthValueInfoLocal local = MonitorTruthValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorTypeId(),
						m_monitorInfo.getMonitorId(),
						value.getPriority(),
						value.getTruthValue(),
						value.getMessageId(),
						value.getMessage(),
						value.getJobRun(),
						value.getJobId(),
						value.getJobInhibitionFlg(),
						value.getJobFailurePriority());
				valueLocalList.add(local);
			}
		}
		if(valueLocalList != null){
			ct.addAll(valueLocalList);
			m_monitor.setMonitorTruthValueInfo(ct);
		}
		
		return true;
	}
}
