/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorTruthValueInfo"
 *           jndi-name="MonitorTruthValueInfo"
 *           schema="MonitorTruthValueInfo" 
 *           type="CMP"
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId","priority","truth_value"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 * 
 * @ejb.persistence 
 *   table-name="cc_monitor_truth_value_info" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorTruthValueInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.monitor.run.ejb.entity.MonitorTruthValueInfoPK"
 *           
 */
public abstract class MonitorTruthValueInfoBean implements EntityBean {

	/**
	*
	* <!-- begin-user-doc -->
	* The  ejbCreate method.
	* <!-- end-user-doc -->
	*
	* <!-- begin-xdoclet-definition --> 
	* @ejb.create-method 
	* <!-- end-xdoclet-definition --> 
	* @generated
	*/
	public MonitorTruthValueInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer priority, 
			Integer truthValue, 
			String messageId, 
			String message,
			Integer jobRun,
			String jobId,
			Integer jobInhibitionFlg,
			Integer jobFailurePriority
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setPriority(priority);
		this.setTruthValue(truthValue);
		this.setMessageId(messageId);
		this.setMessage(message);
		this.setJobRun(jobRun);
		this.setJobId(jobId);
		this.setJobInhibitionFlg(jobInhibitionFlg);
		this.setJobFailurePriority(jobFailurePriority);
		
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_failure_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobFailurePriority.
	 */
	public abstract Integer getJobFailurePriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobFailurePriority The jobFailurePriority to set.
	 */
	public abstract void setJobFailurePriority(Integer jobFailurePriority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobId.
	 */
	public abstract String getJobId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobId The jobId to set.
	 */
	public abstract void setJobId(String jobId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_inhibition_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobInhibitionFlg.
	 */
	public abstract Integer getJobInhibitionFlg();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobInhibitionFlg The jobInhibitionFlg to set.
	 */
	public abstract void setJobInhibitionFlg(Integer jobInhibitionFlg);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="job_run"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the jobRun.
	 */
	public abstract Integer getJobRun();

	/**
	 * @ejb.interface-method
	 * 
	 * @param jobRun The jobRun to set.
	 */
	public abstract void setJobRun(Integer jobRun);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the message.
	 */
	public abstract String getMessage();

	/**
	 * @ejb.interface-method
	 * 
	 * @param message The message to set.
	 */
	public abstract void setMessage(String message);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorBlock.
	 */
	public abstract String getMessageId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param messageId The messageId to set.
	 */
	public abstract void setMessageId(String messageId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return Returns the priority.
	 */
	public abstract Integer getPriority();

	/**
	 * @ejb.interface-method
	 * 
	 * @param priority The description to set.
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="truth_value"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field
	 *  
	 * @ejb.interface-method
	 * 
	 * @return statusFlg The truthValue to set.
	 */
	public abstract Integer getTruthValue();

	/**
	 * @ejb.interface-method
	 * 
	 * @param truthValue The truthValue to set.
	 */
	public abstract void setTruthValue(Integer truthValue);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
    /**
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="MonitorInfo-MonitorTruthValueInfo"
     * role-name="MonitorTruthValueInfo-NotifyInfo(multi)"
     * cascade-delete="yes"
     * 
	 * @jboss.relation
	 * related-pk-field="monitorTypeId"
	 * fk-column="monitor_type_id"
	 * 
	 * @jboss.relation
	 * related-pk-field="monitorId"
	 * fk-column="monitor_id"
	 * 
     */
    public abstract MonitorInfoLocal getMonitorInfo();
    
    /**
     * 
     * @ejb.interface-method view-type="local"
     */
    public abstract void setMonitorInfo(MonitorInfoLocal monitorInfo);
}
