/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.factory;

import java.util.Locale;

import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.util.Messages;

/**
 * イベント情報一括確認用プロパティを作成するクラスです。
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class EventBatchConfirmProperty {

	/** 
	 * 重要度。
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public static final String PRIORITY = "priority";
	/** 受信日時（開始）。 */
	public static final String OUTPUT_FROM_DATE = "outputFromDate";
	/** 受信日時（終了）。 */
	public static final String OUTPUT_TO_DATE = "outputToDate";
	/** 出力日時（開始）。 */
	public static final String GENERATION_FROM_DATE = "generationFromDate";
	/** 出力日時（終了）。 */
	public static final String GENERATION_TO_DATE = "generationToDate";
	/**
	 * ファシリティのターゲット 。
	 * @see com.clustercontrol.bean.FacilityTargetConstant
	 */
	public static final String FACILITY_TYPE = "facilityType";
	/** アプリケーション。 */
	public static final String APPLICATION = "application";
	/** メッセージ。 */
	public static final String MESSAGE = "message";
	
	/** 受信日時。 */
	public static final String OUTPUT_DATE = "outputDate";
	/** 出力日時。 */
	public static final String GENERATION_DATE = "generationDate";
	
	/**
	 * イベント情報一括確認用プロパティを返します。
	 * <p>
	 * <ol>
	 *  <li>フィルタ項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各フィルタ項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義するフィルタ条件は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>重要度（子。コンボボックス）</li>
	 *   <li>受信日時（子。テキスト）</li>
	 *   <ul>
	 *    <li>開始（孫。日時ダイアログ）</li>
	 *    <li>終了（孫。日時ダイアログ）</li>
	 *   </ul>
	 *   <li>出力日時（子。テキスト）</li>
	 *   <ul>
	 *    <li>開始（孫。日時ダイアログ）</li>
	 *    <li>終了（孫。日時ダイアログ）</li>
	 *   </ul>
	 *   <li>ファシリティのターゲット（子。コンボボックス）</li>
	 *   <li>アプリケーション（子。テキスト）</li>
	 *   <li>メッセージ（子。テキスト）</li>
	 *  </ul>
	 * </ul>
	 *  
	 * @param local ロケール情報
	 * @return イベント情報一括確認用プロパティ
	 * 
	 * @see com.clustercontrol.bean.Property
	 * @see com.clustercontrol.bean.PropertyConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.FacilityTargetConstant
	 */
	public Property getProperty(Locale local) {
		
		//重要度
		Property m_priority =
			new Property(PRIORITY, Messages.getString("priority", local), PropertyConstant.EDITOR_SELECT);
		//受信日時（自）
		Property m_outputFromDate =
			new Property(OUTPUT_FROM_DATE, Messages.getString("start", local), PropertyConstant.EDITOR_DATETIME);
		//受信日時（至）
		Property m_outputToDate =
			new Property(OUTPUT_TO_DATE, Messages.getString("end", local), PropertyConstant.EDITOR_DATETIME);
		//出力日時（自）
		Property m_generationFromDate =
			new Property(GENERATION_FROM_DATE, Messages.getString("start", local), PropertyConstant.EDITOR_DATETIME);
		//出力日時（至）
		Property m_generationToDate =
			new Property(GENERATION_TO_DATE, Messages.getString("end", local), PropertyConstant.EDITOR_DATETIME);
		//対象ファシリティ種別
		Property m_facilityType =
			new Property(FACILITY_TYPE, Messages.getString("facility.target", local), PropertyConstant.EDITOR_SELECT);
		//アプリケーション
		Property m_application =
			new Property(APPLICATION, Messages.getString("application", local), PropertyConstant.EDITOR_TEXT);
		//メッセージ
		Property m_message =
			new Property(MESSAGE, Messages.getString("message", local), PropertyConstant.EDITOR_TEXT);
		//受信日時
		Property m_outputDate = 
			new Property(OUTPUT_DATE, Messages.getString("receive.time", local), PropertyConstant.EDITOR_TEXT);
		//出力日時
		Property m_generationDate = 
			new Property(GENERATION_DATE, Messages.getString("output.time", local), PropertyConstant.EDITOR_TEXT);

		//値を初期化
		
		Object priorityValues[][] = { 
				{ "", PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}, 
				{ "", PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}};
				
		m_priority.setSelectValues(priorityValues);
		m_priority.setValue(PriorityConstant.STRING_CRITICAL);
		
		m_outputFromDate.setValue("");
		m_outputToDate.setValue("");
		m_generationFromDate.setValue("");
		m_generationToDate.setValue("");

		Object facilityTypeValues[][] = {
				{ FacilityTargetConstant.STRING_ALL, FacilityTargetConstant.STRING_BENEATH}, 
				{ FacilityTargetConstant.STRING_ALL, FacilityTargetConstant.STRING_BENEATH}};

		m_facilityType.setSelectValues(facilityTypeValues);
		m_facilityType.setValue(FacilityTargetConstant.STRING_ALL);
		
		m_application.setValue("");
		m_message.setValue("");
		
		m_outputDate.setValue("");
		m_generationDate.setValue("");
		
		//変更の可/不可を設定
		m_priority.setModify(PropertyConstant.MODIFY_OK);
		m_outputFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_outputToDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationToDate.setModify(PropertyConstant.MODIFY_OK);
		m_facilityType.setModify(PropertyConstant.MODIFY_OK);
		m_application.setModify(PropertyConstant.MODIFY_OK);
		m_message.setModify(PropertyConstant.MODIFY_OK);
				
		m_outputDate.setModify(PropertyConstant.MODIFY_NG);
		m_generationDate.setModify(PropertyConstant.MODIFY_NG);

		Property property = new Property(null, null, "");
		
		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_priority);
		property.addChildren(m_outputDate);
		property.addChildren(m_generationDate);
		property.addChildren(m_facilityType);
		property.addChildren(m_application);
		property.addChildren(m_message);
		
		// 受信日時
		m_outputDate.removeChildren();
		m_outputDate.addChildren(m_outputFromDate);
		m_outputDate.addChildren(m_outputToDate);

		// 出力日時
		m_generationDate.removeChildren();
		m_generationDate.addChildren(m_generationFromDate);
		m_generationDate.addChildren(m_generationToDate);
		
		return property;
	}
}
