/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * 監視管理コアプラグインクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class MonitorCorePlugin extends AbstractUIPlugin {
	
	/** プラグインのインスタンス */
    private static MonitorCorePlugin plugin;

    /** リソースバンドルインスタンス */
    private ResourceBundle resourceBundle;

    /**
	 * コンストラクタ<BR>
	 * リソースバンドルを取得します。
	 */
    public MonitorCorePlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.monitor.core.MonitorCorePluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * プラグイン 開始。
     * プラグインの活性化の際に呼ばれます。
     * 
     * @param context BundleContextオブジェクト
     * @throws Exception
     * 
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * プラグイン 停止。
     * プラグインの非活性化の際に呼ばれます。
     * 
     * @param context BundleContextオブジェクト
     * @throws Exception
     * 
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * 監視管理コアプラグインのインスタンスを返します。
     * 
     * @return 監視管理コアプラグインのインスタンス
     */ 
    public static MonitorCorePlugin getDefault() {
        return plugin;
    }

    /**
     * 監視管理コアプラグインのリソースバンドルから、
     * キーに該当する文字列を返します。
     * 
     * @param key キー
     * @return 文字列。リソースバンドルが無い場合、もしくは指定した文字列 が存在しない場合は、keyを返します。
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = MonitorCorePlugin.getDefault()
                .getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
	 * 監視管理コアプラグインのリソースバンドルを返します。
	 * 
	 * @return リソースバンドル
	 */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }
}