/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.PropertyUtil;

/**
 * 監視[ステータス]ビューの一覧情報を取得するクラスです。
 * 
 * マネージャにSessionBean経由でアクセスし、ステータス一覧情報を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetFilterStatus {

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、ステータス一覧情報を返します。
     * 
     * @param facilityId 取得対象の親ファシリティID
	 * @return ステータス情報一覧（Objectの2次元配列）
     * @throws AccessException 
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getStatusList(String)
     */
    public ArrayList getFilterInfo(String facilityId) throws AccessException {

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        ArrayList records = null;
        try {
            records = monitor.getStatusList(facilityId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、条件にマッチしたステータス監視情報を返します。
     * 
     * @param facilityId 取得対象の親ファシリティID
	 * @param condition 検索条件
	 * @return ステータス情報一覧（Objectの2次元配列）
     * @throws AccessException 
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getStatusList(String, Property)
     */
    public ArrayList getFilterInfo(String facilityId, Property condition) throws AccessException {

        PropertyUtil.deletePropertyDefine(condition);

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        ArrayList records = null;
        try {
            records = monitor.getStatusList(facilityId, condition);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合
				throw (AccessException) e;
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}