/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 監視[イベント]ビューのテーブル定義を取得するクラスです。
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetEventListTableDefine {

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、監視[イベント]ビューのテーブル定義情報を取得します。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#getEventListTableDefine(Locale)
     */
    public static ArrayList get() {
        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        ArrayList tableDefine = null;
        try {
            tableDefine = monitor.getEventListTableDefine(Locale.getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        }
        return tableDefine;
    }
}