/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.ejb.session.MonitorController;
import com.clustercontrol.monitor.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * イベント情報の確認を更新するクラスです。
 * 
 * マネージャにSessionBean経由でアクセスし、イベント情報の確認を更新します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ConfirmEvent {

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたイベント情報一覧の確認を済に更新します。<BR>
     * <p>指定されたリストには、各イベント情報のリスト（{@link ArrayList}）が格納されています。
	 * また、１イベント情報の各値は、テーブルのカラム順（{@link com.clustercontrol.monitor.bean.EventTabelDefine}）にリストに格納されています。
	 * <p>
	 * <dl>
	 *  <dt>イベント情報一覧（Objectの2次元配列）</dt>
	 *  <dd>{ イベント情報1 {カラム1の値, カラム2の値, … }, イベント情報2{カラム1の値, カラム2の値, …}, … }</dd>
	 * </dl>
     * 
     * @param list 更新対象のイベント情報一覧（Objectの2次元配列）
     * @return 更新に成功した場合、</code> true </code>
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#modifyConfirm(List, int)
     */
    public boolean confirm(List list) {

        if (list != null && list.size()>0) {
        	
            MonitorController monitor = EjbConnectionManager
                    .getConnectionManager().getMonitorController();

            try {
                monitor.modifyConfirm(list, ConfirmConstant.TYPE_CONFIRMED);
                return true;
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// アクセス権なしの場合、エラーダイアログを表示する
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
            } catch (CreateException e) {
            } catch (FinderException e) {
            } catch (NamingException e) {
            }
        }
        return false;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定されたイベント情報一覧の確認を未に更新します。<BR>
     * <p>指定されたリストには、各イベント情報のリスト（{@link ArrayList}）が格納されています。
	 * また、１イベント情報の各値は、テーブルのカラム順（{@link com.clustercontrol.monitor.bean.EventTabelDefine}）にリストに格納されています。
	 * <p>
	 * <dl>
	 *  <dt>イベント情報一覧（Objectの2次元配列）</dt>
	 *  <dd>{ イベント情報1 {カラム1の値, カラム2の値, … }, イベント情報2{カラム1の値, カラム2の値, …}, … }</dd>
	 * </dl>
     * 
     * @param list 更新対象のイベント情報一覧（Objectの2次元配列）
     * @return 更新に成功した場合、</code> true </code>
     * 
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#modifyConfirm(List, int)
     */
    public boolean unconfirm(List list) {

        if (list != null && list.size()>0) {
        	
            MonitorController monitor = EjbConnectionManager
                    .getConnectionManager().getMonitorController();

            try {
                monitor.modifyConfirm(list, ConfirmConstant.TYPE_UNCONFIRMED);
                return true;
            } catch (RemoteException e) {
    			if(e instanceof AccessException){
    				// アクセス権なしの場合、エラーダイアログを表示する
    	            MessageDialog.openInformation(null, Messages.getString("message"),
    	                    Messages.getString("message.accesscontrol.16"));
    			}
            } catch (CreateException e) {
            } catch (FinderException e) {
            } catch (NamingException e) {
            }
        }
        return false;
    }

    /**
     * マネージャにSessionBean経由でアクセスし、引数で指定された条件に一致するイベント情報の確認を一括更新します。
     * 
     * @param confirmType 確認フラグ（未／済）（更新値）
     * @param facilityId ファシリティID
     * @param condition 更新条件
     * @return 更新に成功した場合、</code> true </code>
     * 
     * @see com.clustercontrol.bean.ConfirmConstant
     * @see com.clustercontrol.monitor.util.EjbConnectionManager
     * @see com.clustercontrol.monitor.ejb.session.MonitorController
     * @see com.clustercontrol.monitor.ejb.session.MonitorControllerBean#modifyBatchConfirm(int, String, Property)
     */
    public boolean confirmBatch(int confirmType, String facilityId,
            Property condition) {

        PropertyUtil.deletePropertyDefine(condition);

        MonitorController monitor = EjbConnectionManager.getConnectionManager()
                .getMonitorController();

        try {
            monitor.modifyBatchConfirm(confirmType, facilityId, condition);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
		} catch (SQLException e) {
		}
        return false;
    }
}