/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.factory;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.bean.QueueConstant;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoUtil;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.logtransfer.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * ログ転送情報更新クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyLogTransfer {
	
	protected static Log m_log = LogFactory.getLog( ModifyLogTransfer.class );
	
	/**
	 * ログ転送情報を更新
	 * 
	 * @param info ログ転送情報
	 * @param user ユーザ
	 * @return 更新に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public boolean modify(LogTransferInfo info, String user) throws CreateException, FinderException, RemoveException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.LOG_TRANSFER);
		
		try 
		{
			// ログ転送情報を取得
			LogTransferInfoLocal logTransfer = LogTransferInfoUtil.getLocalHome().findByPrimaryKey(info.getTransferId());
			
			// ログ転送情報を更新
			if(logTransfer != null){
				logTransfer.setDescription(info.getDescription());
				logTransfer.setFacilityId(info.getFacilityId());
				logTransfer.setValidFlg(Integer.valueOf(info.getValid()));
				logTransfer.setUpdateDate(new Timestamp(new Date().getTime()));
				logTransfer.setUpdateUser(user);
			}
			Collection ct = logTransfer.getLogTransferFileInfo();
			
			// 転送対象ログファイル情報を削除
			DeleteLogTransfer delete = new DeleteLogTransfer();
			delete.deleteFiles(ct);
			
			// 転送対象ログファイル情報を挿入
			ArrayList<LogTransferFileInfo> fileList = info.getFileInfo();
			ArrayList<LogTransferFileInfoLocal> fileLocalList = new ArrayList<LogTransferFileInfoLocal>();
			
			LogTransferFileInfo file = null;
			for(int index=0; index<fileList.size(); index++){
				file = (LogTransferFileInfo)fileList.get(index);
				if(file != null){
					LogTransferFileInfoLocal local = LogTransferFileInfoUtil.getLocalHome().create(
							info.getTransferId(),
							file.getFilePath(),
							Integer.valueOf(file.getRunInterval()),
							Integer.valueOf(file.getExistenceFlg()),
							Integer.valueOf(file.getValid()));
					fileLocalList.add(local);
				}
			}
			if(fileLocalList != null){
				ct.addAll(fileLocalList);
				logTransfer.setLogTransferFileInfo(ct);
			}
			
			try {
				// 転送対象ログファイル管理Queueへ通知
				SendQueue queue = new SendQueue(QueueConstant.QUEUE_NAME_FILE_MANAGE);
				queue.put(info);
				
			} catch (Exception e) {
				m_log.debug("modify() : 更新情報送信エラー : " + e.getMessage());
			}
			
		} catch (CreateException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { info.getTransferId() };
			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { info.getTransferId() };
			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { info.getTransferId() };
			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
			String[] args = { info.getTransferId() };
			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		}
		return true;
	}
	
}
