/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logtransfer.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.logtransfer.bean.LogTransferFileTabelDefine;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.bean.LogTransferTabelDefine;
import com.clustercontrol.logtransfer.factory.AddLogTransfer;
import com.clustercontrol.logtransfer.factory.DeleteLogTransfer;
import com.clustercontrol.logtransfer.factory.ModifyLogTransfer;
import com.clustercontrol.logtransfer.factory.SelectLogTransfer;
import com.clustercontrol.util.Messages;

/**
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="LogTransferController"	
 *           jndi-name="LogTransferController"
 *           type="Stateless"
 *           transaction-type="Container"
 *           
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=SyslogNGController"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *            
 * <!-- end-xdoclet-definition --> 
 * @generated
*/
public abstract class LogTransferControllerBean implements javax.ejb.SessionBean {

	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * ログ転送情報を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ログ転送情報
	 * @return 登録に成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean addLogTransfer(LogTransferInfo info) throws CreateException, NamingException, JMSException {
		
		Principal pri = m_context.getCallerPrincipal();

		// ログ転送情報を登録
		AddLogTransfer logTransfer = new AddLogTransfer();
		return  logTransfer.add(info, pri.getName());
	}
	
	/**
	 * ログ転送情報を更新します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferWrite"
     *     method-intf="Remote"
	 * 
	 * @param info ログ転送情報
	 * @return 変更に成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean modifyLogTransfer(LogTransferInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
		
		Principal pri = m_context.getCallerPrincipal();

		// ログ転送情報を更新
		ModifyLogTransfer logTransfer = new ModifyLogTransfer();
		return  logTransfer.modify(info, pri.getName());
	}
	
	/**
	 * ログ転送情報を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferWrite"
     *     method-intf="Remote"
	 * 
	 * @param transferId ログ転送ID
	 * @return 削除に成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 */
	public boolean deleteLogTransfer(String transferId) throws FinderException, RemoveException, NamingException, JMSException {

		// ログ転送情報を削除
		DeleteLogTransfer logTransfer = new DeleteLogTransfer();
		return  logTransfer.delete(transferId);
	}
	
	/**
	 * ログ転送情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param transferId ログ転送ID
	 * @return ログ転送情報
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public LogTransferInfo getLogTransfer(String transferId) throws CreateException, FinderException, NamingException {

		// ログ転送情報を取得
		SelectLogTransfer logTransfer = new SelectLogTransfer();
		LogTransferInfo info = logTransfer.getLogTransfer(transferId);

		return info;
	}
	
	/**
	 * ログ転送一覧リストを返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="LogTransferRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Objectの2次元配列
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getLogTransferList() throws CreateException, FinderException, NamingException {

		// ログ転送一覧を取得
		SelectLogTransfer logTransfer = new SelectLogTransfer();
		ArrayList list = logTransfer.getLogTransferList();

		return list;
	}
	
	/**
	 * ログ転送一覧のテーブル定義情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale ロケール
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getLogTransferListTableDefine(Locale locale) {
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(LogTransferTabelDefine.TRANSFER_ID, 
				new TableColumnInfo(Messages.getString("logtransfer.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 200, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(LogTransferTabelDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 130, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * 転送対象ログファイル一覧のテーブル定義情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale ロケール
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getLogTransferFileListTableDefine(Locale locale) {
		
		/** テーブル情報定義配列 */
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(LogTransferFileTabelDefine.FILE_PATH, 
				new TableColumnInfo(Messages.getString("file.path", locale), TableColumnInfo.NONE, 300, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.RUN_INTERVAL, 
				new TableColumnInfo(Messages.getString("semantics.interval.sec", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.FILE_EXISTENCE_CHECK, 
				new TableColumnInfo(Messages.getString("file.first.existence.check", locale), TableColumnInfo.CHECKBOX, 170, SWT.LEFT));
		tableDefine.add(LogTransferFileTabelDefine.VALID_FLG, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 80, SWT.LEFT));
		
		return tableDefine;
	}
}
