/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.logagent;

import java.util.Properties;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.bean.QueueConstant;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * Queue送信クラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class SendQueue {

	private static final String QUEUE_CON_FACTORY = "ConnectionFactory";

	private static final String QUEUE_USER_NAME = "queue.user.name";

	private static final String QUEUE_USER_PASSWORD = "queue.user.password";

	private Properties m_props;

	private QueueConnection m_con;

	private Queue m_queueLog;

	private Queue m_queueFacility;

	private QueueSession m_session;

	private QueueConnectionFactory m_factory;

	private boolean m_isErr = false;

	//ロガー
	static private Log log = LogFactory.getLog(SendQueue.class);
    
	/**
	 * コンストラクタ
	 * @param props プロパティファイル情報
	 */
	public SendQueue(Properties props) {
		super();
		m_props = props;
		
		initial();
	}

	/**
	 *  再接続処理
	 */
	synchronized private boolean reInitial() {

		boolean ret = false;

		log.info("再接続処理!");

		terminate();

		if (initial()) {

			ret = true;

			log.info("再接続処理:成功!");

			//エラーフラグ解除
			m_isErr = false;


		} else {
			log.info("再接続処理:失敗!");
		}

		return ret;
	}
	/**
	 * サーバ接続の終了処理
	 *  
	 */
	public void terminate() {

		try {
			if (m_session != null)
				m_session.close();
		} catch (JMSException e) {
		}

		try {
			if (m_con != null)
				m_con.close();
		} catch (JMSException e1) {
		}
	}

    /**
     * メッセージ送信処理
	 * 実行応答メッセージを送信する。
	 * 処理失敗は1回再試行する。
	 * @param msg
	 */
	synchronized public boolean put(Object info) {

		if (m_isErr) {
			reInitial();
		}

		QueueSender sender = null;
		Message mess = null;

		for(int i = 0; i < 2 ;i ++) {
			try {
				
				if (info instanceof LogOutputInfo) {
					//監視機能へ送信
					//Sender作成
					sender = m_session.createSender(m_queueLog);
					//メッセージ作成
					mess = m_session.createObjectMessage((LogOutputInfo)info);
					
				}else if (info instanceof String) {
					//ログ転送へファシリティID送信
					//Sender作成
					sender = m_session.createSender(m_queueFacility);
					//メッセージ作成
					mess = m_session.createTextMessage((String)info);
					
				}else{
					return false;
				}
				
				//送信
				log.info("オブジェクトメッセージ送信!");
				sender.send(mess);
				
				return true;
	
			} catch (JMSException e) {
				log.error(e);
				log.info("オブジェクトメッセージ送信リトライ");
				
				try {
					wait(1000);
				} catch (InterruptedException e1) {
				}
				
				if(!reInitial()){
					return false;
				}
	
			} finally {
				try {
					if (sender != null)
						sender.close();
				} catch (Exception e1) {
				}
			}
		}
		return false;
	}


	/**
	 * 接続初期化処理
	 * @return
	 */
    private boolean initial() {

		log.info("EJB接続初期化");

		InitialContext con = null;

		try {
			//InitialContextの生成
			con = new InitialContext(m_props);

			//コネクションファクトリ生成
			m_factory = (QueueConnectionFactory) con.lookup(QUEUE_CON_FACTORY);

			//コネクション生成
			if (m_props.getProperty(QUEUE_USER_NAME) != null) {
				//ユーザ認証
				m_con = m_factory.createQueueConnection(m_props
						.getProperty(QUEUE_USER_NAME), m_props
						.getProperty(QUEUE_USER_PASSWORD));
			} else {
				//ユーザ認証なし
				m_con = m_factory.createQueueConnection();
			}

			
			//セッション生成
			m_session = m_con.createQueueSession(false,
					Session.AUTO_ACKNOWLEDGE);
			
			//コネクション開始
			m_con.start();

			//メッセージQueue取得
			m_queueLog = (Queue) con.lookup(QueueConstant.QUEUE_NAME_LOG);
			m_queueFacility = (Queue) con.lookup(com.clustercontrol.logtransfer.bean.QueueConstant.QUEUE_NAME_FILE_MANAGE);

			
			

		} catch (Exception e) {
			log.error("Init", e);
			m_isErr = true;
			return false;
		} finally {
			try {
				if (con != null)
					con.close();
			} catch (Exception e1) {
			}
		}
		return true;

	}
	
}
