/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.action.GetJobOperationProperty;
import com.clustercontrol.jobmanagement.action.OperationJob;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.composite.NodeDetailComposite;
import com.clustercontrol.jobmanagement.dialog.JobOperationDialog;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.util.Messages;

/**
 * ジョブ停止操作アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StopJobAction implements IViewActionDelegate {
    public static final String ID = "com.clustercontrol.jobmanagement.view.action.StopJobAction";

    protected IViewPart m_view;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        String sessionId = null;
        String jobId = null;
        String facilityId = null;

        if (m_view instanceof JobHistoryView) { // ボタンが押された場合
            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);
            HistoryComposite historyComposite = view.getComposite();
            //セッションID取得
            sessionId = historyComposite.getSessionId();
            //ジョブID取得
            jobId = historyComposite.getJobId();
        } else if (m_view instanceof JobDetailView) { // ボタンが押された場合
            JobDetailView view = (JobDetailView) m_view
                    .getAdapter(JobDetailView.class);
            DetailComposite detailComposite = view.getComposite();
            //セッションID取得
            sessionId = detailComposite.getSessionId();
            //ジョブID取得
            jobId = detailComposite.getJobId();
        } else if (m_view instanceof JobNodeDetailView) { // ボタンが押された場合
            JobNodeDetailView view = (JobNodeDetailView) m_view
                    .getAdapter(JobNodeDetailView.class);
            NodeDetailComposite nodeDetailComposite = view.getComposite();
            //セッションID取得
            sessionId = nodeDetailComposite.getSessionId();
            //ジョブID取得
            jobId = nodeDetailComposite.getJobId();
            //ファシリティID取得
            facilityId = nodeDetailComposite.getFacilityId();
            if (facilityId == null) {
                sessionId = null;
                jobId = null;
            }
        }

        if (sessionId != null && sessionId.length() > 0 && jobId != null
                && jobId.length() > 0) {

            JobOperationDialog dialog = new JobOperationDialog(PlatformUI
                    .getWorkbench().getActiveWorkbenchWindow().getShell());

            //プロパティ設定
            dialog.setProperty(new GetJobOperationProperty().getStopProperty(
                    sessionId, jobId, facilityId));
            dialog.setTitleText(Messages.getString("job") + "["
                    + Messages.getString("stop") + "]");

            //ダイアログ表示
            if (dialog.open() == IDialogConstants.OK_ID) {
                //ジョブ停止
                OperationJob operation = new OperationJob();
                operation.operationJob(dialog.getProperty());
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}