/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.dialog.HistoryFilterDialog;
import com.clustercontrol.jobmanagement.view.JobHistoryView;

/**
 * ジョブ検索表示アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistoryFilterAction implements IViewActionDelegate {
    protected IViewPart m_view;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        if (action.isChecked()) { // ボタンが押された場合

            HistoryFilterDialog dialog = new HistoryFilterDialog(PlatformUI
                    .getWorkbench().getActiveWorkbenchWindow().getShell());

            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);

            //ジョブ履歴フィルタダイアログを表示
            if (dialog.open() == IDialogConstants.OK_ID) {
                // ジョブ履歴ビューをフィルタモードで表示
                Property property = dialog.getInputData();
                view.setFilterCondition(property);
                view.update();
            } else {
                action.setChecked(false);
            }
        } else { // ボタンが戻った場合
            // ジョブ履歴ビューを通常モードで表示
            JobHistoryView view = (JobHistoryView) m_view
                    .getAdapter(JobHistoryView.class);
            view.setFilterCondition(null);
            view.update();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }

}