/*
/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.util.Messages;

/**
 * キャンセルアクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CancelJobAction implements IViewActionDelegate {
    protected IViewPart m_view;

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        m_view = view;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        if (m_view instanceof JobListView) {
            JobListView view = (JobListView)m_view.getAdapter(JobListView.class);
            
            // 確認ダイアログを生成
            MessageBox box1 = new MessageBox(m_view.getSite().getShell(),
                    SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
            box1.setText(Messages.getString("confirmed"));
            
            if(view.isUpdate()){
                box1.setMessage(Messages.getString("message.job.43") + "\n" + 
                        Messages.getString("message.job.30"));
            }
            else{
                box1.setMessage(Messages.getString("message.job.30"));
            }
            if (box1.open() == SWT.OK) {
                view.update();
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {

    }
}