/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import java.util.Calendar;
import java.util.Date;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.calendar.view.action.CalendarAddAction;
import com.clustercontrol.calendar.view.action.CalendarDeleteAction;
import com.clustercontrol.calendar.view.action.CalendarModifyAction;
import com.clustercontrol.jobmanagement.composite.RunScheduleDetailComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleDetailListComposite;
import com.clustercontrol.view.CommonViewPart;

/**
 * 予定詳細ビュークラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleDetailListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.RunScheduleDetailListView";

	private SashForm m_sash = null;
	
    private RunScheduleDetailListComposite m_runScheduleList = null;
    
	private RunScheduleDetailComposite m_runSchedule = null;
	
    protected Date m_base = null;
	
    /**
     * コンストラクタ
     */
    public RunScheduleDetailListView() {
        super();
    }

    /**
     * ViewPartへのコントロール作成処理
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

		// サッシュフォーム作成及び設定
        m_sash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		m_sash.setLayoutData(gridData);
		
        m_runScheduleList = new RunScheduleDetailListComposite(m_sash, SWT.NONE);

        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(new Date());
        baseCalendar.add(Calendar.WEEK_OF_MONTH, -1);
        m_base = new Date();
        m_runSchedule = new RunScheduleDetailComposite(m_sash, SWT.NONE, baseCalendar.getTime());
        
		// Sashの境界を調整 左部50% 右部50%
//        m_sash.setWeights(new int[] { 50, 50 });

        //ビューを更新
        this.update(null);
    }

    /**
     * 予定詳細ビュー更新
     */
    public void update(String scheduleId) {
    	m_runScheduleList.update(scheduleId);
    	
    	if(!m_base.equals(m_runSchedule.getBaseDate())){
    		//ScheduleComposite作成
    		CreateScheduleComposite();
    	}
    	
    	m_runSchedule.update(scheduleId);
    }
    
    /**
     * ScheduleComposite作成
     */
    public void CreateScheduleComposite() {
		//ScheduleComposite解放
    	m_runSchedule.dispose();
		
        m_runSchedule = new RunScheduleDetailComposite(m_sash, SWT.NONE, m_base);
	    
	    //SashForm再描画
        m_sash.layout(true, true);
    }
    
	/**
	 * @return
	 */
	public RunScheduleDetailListComposite getListComposite() {
		return m_runScheduleList;
	}
	
	/**
	 * @return
	 */
	public RunScheduleDetailComposite getScheduleComposite() {
		return m_runSchedule;
	}

	/**
	 * 表示します。
	 */
	public void showSchedule() {
		m_sash.setMaximizedControl(null);
	}
	
	/**
	 * 隠します。
	 */
	public void hideSchedule() {
		m_sash.setMaximizedControl(m_runScheduleList);
	}
    
	/**
	 * @return
	 */
	public Date getBaseDate() {
		return m_base;
	}
	
	/**
	 * @param base
	 */
	public void setBaseDate(Date base) {
		m_base = base;
	}
}