/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.preference.JobManagementPreferencePage;
import com.clustercontrol.jobmanagement.ui.JobManagementUIPlugin;
import com.clustercontrol.jobmanagement.view.action.StartJobAction;
import com.clustercontrol.jobmanagement.view.action.StopJobAction;
import com.clustercontrol.view.AutoUpdateView;

/**
 * ジョブ履歴ビュークラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobHistoryView extends AutoUpdateView {
    public static final String ID = "com.clustercontrol.jobmanagement.view.JobHistoryView";

    private HistoryComposite m_history = null;

    /** フィルタ条件 */
    private Property m_condition = null;

    /**
     * コンストラクタ
     * 
     * @since 1.0.0
     */
    public JobHistoryView() {
        super();
    }

    /**
     * ViewPartへのコントロール作成処理
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_history = new HistoryComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_history.setLayoutData(gridData);

        //ポップアップメニュー作成
        createContextMenu();

        //ビューを更新
        this.update();

        // 設定情報反映
        IPreferenceStore store = JobManagementUIPlugin.getDefault()
                .getPreferenceStore();

        this.setInterval(store
                .getInt(JobManagementPreferencePage.P_HISTORY_UPDATE_CYCLE));

        if (store.getBoolean(JobManagementPreferencePage.P_HISTORY_UPDATE_FLG)) {
            this.startAutoReload();
        }
    }

    /**
     * ポップアップメニュー作成
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_history.getTable());
        m_history.getTable().setMenu(menu);
    }

    /**
     * メニュー項目追加
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem startJobAction = (ActionContributionItem) toolbar
                .find(StartJobAction.ID);
        ActionContributionItem stopJobAction = (ActionContributionItem) toolbar
                .find(StopJobAction.ID);

        //ポップアップメニューにアクションを追加
        manager.add(startJobAction.getAction());
        manager.add(stopJobAction.getAction());
    }

    /**
     * フィルタ条件取得
     * 
     * @return フィルタ条件
     */
    public Property getFilterCondition() {
        return m_condition;
    }

    /**
     * フィルタ条件設定
     * 
     * @param condition
     *            フィルタ条件
     */
    public void setFilterCondition(Property condition) {
        m_condition = condition;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.view.AutoUpdateView#update()
     */
    public void update() {
        if (m_condition == null) {
            m_history.update();
        } else {
            m_history.update(m_condition);
        }
    }

    /**
     * コンポジット取得処理
     * 
     * @return
     */
    public HistoryComposite getComposite() {
        return m_history;
    }
}