/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.jobmanagement.composite.ForwardFileComposite;
import com.clustercontrol.view.CommonViewPart;

/**
 * ファイル転送ビュークラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ForwardFileView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.jobmanagement.view.ForwardFileView";

    private ForwardFileComposite m_composite = null;

    /**
     * コンストラクタ
     * 
     * @since 1.0.0
     */
    public ForwardFileView() {
        super();
    }

    /**
     * ViewPartへのコントロール作成処理
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_composite = new ForwardFileComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_composite.setLayoutData(gridData);

        //ビューの更新
        this.update(null, null);
    }

    /**
     * 更新処理
     * 
     * @since 1.0.0
     */
    public void update(String sessionId, String jobId) {
    	m_composite.update(sessionId, jobId);
    }

    /**
     * コンポジット取得処理
     * 
     * @return
     */
    public ForwardFileComposite getComposite() {
        return m_composite;
    }
}