/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

import com.clustercontrol.jobmanagement.ui.JobManagementUIPlugin;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.util.Messages;

/**
 * ジョブ管理機能の設定ページクラスです。
 * 
 * @version 2.1.1
 * @since 1.0.0
 */
public class JobManagementPreferencePage extends FieldEditorPreferencePage
        implements IWorkbenchPreferencePage {

    /** ジョブ[履歴]ビューの自動更新フラグ */
    public static final String P_HISTORY_UPDATE_FLG = "historyUpdateFlg";

    /** ジョブ[履歴]ビューの自動更新周期 */
    public static final String P_HISTORY_UPDATE_CYCLE = "historyUpdateCycle";

    /** ジョブ[履歴]ビューのメッセージ表示 */
    public static final String P_HISTORY_MESSAGE_FLG = "historyMessageFlg";
    
    /** ジョブ[履歴]ビューの表示履歴数 */
    public static final String P_HISTORY_MAX_HISTORIES = "historyMaxHistories";
    
    /**
     * 初期値が設定されたインスタンスを返します。
     */
    public JobManagementPreferencePage() {
        super(GRID);
        this.setPreferenceStore(JobManagementUIPlugin.getDefault()
                .getPreferenceStore());

        this.initializeDefaults();
    }

    /**
     * 初期値を設定します。
     */
    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();

        store.setDefault(P_HISTORY_UPDATE_FLG, true);
        store.setDefault(P_HISTORY_UPDATE_CYCLE, 10);
        store.setDefault(P_HISTORY_MESSAGE_FLG, true);
        store.setDefault(P_HISTORY_MAX_HISTORIES, 500);
    }

    /**
     * 設定フィールドを生成します。
     */
    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        // ジョブ[履歴]ビュー関連
        Group group = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData(gridData);
        group.setText(Messages.getString("view.job.history"));
        // フラグ
        this.addField(new BooleanFieldEditor(P_HISTORY_UPDATE_FLG, 
        		Messages.getString("autoupdate.enable"), group));
        // 周期
        this.addField(new IntegerFieldEditor(P_HISTORY_UPDATE_CYCLE, 
        		Messages.getString("autoupdate.cycle") + " : ", group));
        // メッセージ表示
        this.addField(new BooleanFieldEditor(P_HISTORY_MESSAGE_FLG, 
        		Messages.getString("over.limit.message"), group));
        // 表示履歴数
        this.addField(new IntegerFieldEditor(P_HISTORY_MAX_HISTORIES, 
        		Messages.getString("number.of.display.histories") + " : ", group));
    }

    /**
     * 設定内容を各ビューに反映します。
     * 
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        boolean result = super.performOk();

        this.applySetting();

        return result;
    }

    /**
     * 設定内容を反映します。
     */
    protected void applySetting() {
        IPreferenceStore store = this.getPreferenceStore();

        // 存在するビュー全てに設定を適応する。

        IWorkbench workbench = JobManagementUIPlugin.getDefault()
                .getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();

        int windowCount = windows.length;

        for (int i = 0; i < windowCount; i++) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int pageCount = pages.length;

            for (int j = 0; j < pageCount; j++) {
                JobHistoryView view = (JobHistoryView) pages[j]
                        .findView(JobHistoryView.ID);
                if (view != null) {
                    int cycle = store.getInt(P_HISTORY_UPDATE_CYCLE);
                    view.setInterval(cycle);
                    if (store.getBoolean(P_HISTORY_UPDATE_FLG)) {
                        view.startAutoReload();
                    } else {
                        view.stopAutoReload();
                    }
                }
            }
        }
    }

    public void init(IWorkbench workbench) {
    }
}