/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;

/**
 * ジョブ操作ダイアログクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobOperationDialog extends CommonDialog {
    protected Property m_property = null;

    protected PropertySheet m_propertySheet = null;

    protected boolean m_processingMethod = true;

    protected String m_title = "";

    public JobOperationDialog(Shell parent) {
        super(parent);
    }

    /**
     * ダイアログの初期サイズを返します。
     * 
     * @return 初期サイズ
     */
    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        shell.setText(m_title);

        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        // プロパティシート
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);
        m_propertySheet = new PropertySheet(table);
        m_propertySheet.setInput(m_property);

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * プロパティ取得
     * 
     * @return Returns the jobId.
     */
    public Property getProperty() {
        return m_property;
    }

    /**
     * プロパティ設定
     * 
     * @param property
     */
    public void setProperty(Property property) {
        m_property = property;
    }

    /**
     * ダイアログタイトル取得
     * 
     * @return
     */
    public String getTitleText() {
        return m_title;
    }

    /**
     * ダイアログタイトル設定
     * 
     * @param title
     */
    public void setTitleText(String title) {
        m_title = title;
    }

    /**
     * ＯＫボタンテキスト取得
     * 
     * @return ＯＫボタンのテキスト
     * @since 1.0.0
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * キャンセルボタンテキスト取得
     * 
     * @return キャンセルボタンのテキスト
     * @since 1.0.0
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {
        return null;
    }
}