/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.action.GetSessionJobInfo;
import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.dialog.JobDialog;

/**
 * 履歴一覧テーブル及びジョブ詳細テーブルのDoubleClickListenerクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class SessionJonDoubleClickListener implements IDoubleClickListener {
    protected Composite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite
     * @since 2.0.0
     */
    public SessionJonDoubleClickListener(Composite composite) {
        m_composite = composite;
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IDoubleClickListener#doubleClick(org.eclipse.jface.viewers.DoubleClickEvent)
	 */
	public void doubleClick(DoubleClickEvent event) {
        String sessionId = null;
        String jobId = null;

		if(m_composite instanceof HistoryComposite){
	        //セッションIDとジョブIDを取得
	        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
	            ArrayList info = (ArrayList) ((StructuredSelection) event
	                    .getSelection()).getFirstElement();
	            sessionId = (String)info.get(HistoryTableDefine.SESSION_ID);
	            jobId = (String)info.get(HistoryTableDefine.JOB_ID);
	        }
		}
		else if(m_composite instanceof DetailComposite){
	        //セッションIDとジョブIDを取得
	        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
	            CommonTableTreeItem item = (CommonTableTreeItem) ((StructuredSelection) event
	                    .getSelection()).getFirstElement();
	            ArrayList info = item.getData();
	            sessionId = ((DetailComposite)m_composite).getSessionId();
	            jobId = (String)info.get(JobDetailTableDefine.JOB_ID);
	        }
		}
		
		if(sessionId != null && sessionId.length() > 0 && 
				jobId != null && jobId.length() > 0){
		
			JobTreeItem item = new GetSessionJobInfo().getJobTree(sessionId, jobId);
			if(item != null){
		        JobDialog dialog = new JobDialog(
		        		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
		        		true);
		        
		        dialog.setJobTreeItem(item);
		        dialog.open();
			}
		}
	}

}
